/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker;

import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.forms.account.AccountPages;
import org.keycloak.forms.account.AccountProvider;
import org.keycloak.forms.account.freemarker.Templates;
import org.keycloak.forms.account.freemarker.model.AccountBean;
import org.keycloak.forms.account.freemarker.model.AccountFederatedIdentityBean;
import org.keycloak.forms.account.freemarker.model.ApplicationsBean;
import org.keycloak.forms.account.freemarker.model.AuthorizationBean;
import org.keycloak.forms.account.freemarker.model.FeaturesBean;
import org.keycloak.forms.account.freemarker.model.LogBean;
import org.keycloak.forms.account.freemarker.model.PasswordBean;
import org.keycloak.forms.account.freemarker.model.RealmBean;
import org.keycloak.forms.account.freemarker.model.ReferrerBean;
import org.keycloak.forms.account.freemarker.model.SessionsBean;
import org.keycloak.forms.account.freemarker.model.TotpBean;
import org.keycloak.forms.account.freemarker.model.UrlBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.theme.BrowserSecurityHeaderSetup;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.FreeMarkerUtil;
import org.keycloak.theme.Theme;
import org.keycloak.theme.beans.AdvancedMessageFormatterMethod;
import org.keycloak.theme.beans.LocaleBean;
import org.keycloak.theme.beans.MessageBean;
import org.keycloak.theme.beans.MessageFormatterMethod;
import org.keycloak.theme.beans.MessageType;
import org.keycloak.theme.beans.MessagesPerFieldBean;
import org.keycloak.utils.MediaType;

public class FreeMarkerAccountProvider
implements AccountProvider {
    private static final Logger logger = Logger.getLogger(FreeMarkerAccountProvider.class);
    protected UserModel user;
    protected MultivaluedMap<String, String> profileFormData;
    protected Response.Status status = Response.Status.OK;
    protected RealmModel realm;
    protected String[] referrer;
    protected List<Event> events;
    protected String stateChecker;
    protected List<UserSessionModel> sessions;
    protected boolean identityProviderEnabled;
    protected boolean eventsEnabled;
    protected boolean passwordUpdateSupported;
    protected boolean passwordSet;
    protected KeycloakSession session;
    protected FreeMarkerUtil freeMarker;
    protected HttpHeaders headers;
    protected Map<String, Object> attributes;
    protected UriInfo uriInfo;
    protected List<FormMessage> messages = null;
    protected MessageType messageType = MessageType.ERROR;
    private boolean authorizationSupported;

    public FreeMarkerAccountProvider(KeycloakSession session, FreeMarkerUtil freeMarker) {
        this.session = session;
        this.freeMarker = freeMarker;
    }

    public AccountProvider setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public AccountProvider setHttpHeaders(HttpHeaders httpHeaders) {
        this.headers = httpHeaders;
        return this;
    }

    public Response createResponse(AccountPages page) {
        Theme theme;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.attributes != null) {
            attributes.putAll(this.attributes);
        }
        try {
            theme = this.getTheme();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create theme", (Throwable)e);
            return Response.serverError().build();
        }
        Locale locale = this.session.getContext().resolveLocale(this.user);
        Properties messagesBundle = this.handleThemeResources(theme, locale, attributes);
        URI baseUri = this.uriInfo.getBaseUri();
        UriBuilder baseUriBuilder = this.uriInfo.getBaseUriBuilder();
        for (Map.Entry e : this.uriInfo.getQueryParameters().entrySet()) {
            baseUriBuilder.queryParam((String)e.getKey(), ((List)e.getValue()).toArray());
        }
        URI baseQueryUri = baseUriBuilder.build(new Object[0]);
        if (this.stateChecker != null) {
            attributes.put("stateChecker", this.stateChecker);
        }
        this.handleMessages(locale, messagesBundle, attributes);
        if (this.referrer != null) {
            attributes.put("referrer", new ReferrerBean(this.referrer));
        }
        if (this.realm != null) {
            attributes.put("realm", new RealmBean(this.realm));
        }
        attributes.put("url", new UrlBean(this.realm, theme, baseUri, baseQueryUri, this.uriInfo.getRequestUri(), this.stateChecker));
        if (this.realm.isInternationalizationEnabled()) {
            UriBuilder b = UriBuilder.fromUri((URI)baseQueryUri).path(this.uriInfo.getPath());
            attributes.put("locale", new LocaleBean(this.realm, locale, b, messagesBundle));
        }
        attributes.put("features", new FeaturesBean(this.identityProviderEnabled, this.eventsEnabled, this.passwordUpdateSupported, this.authorizationSupported));
        attributes.put("account", new AccountBean(this.user, this.profileFormData));
        switch (page) {
            case TOTP: {
                attributes.put("totp", new TotpBean(this.session, this.realm, this.user, this.uriInfo.getRequestUriBuilder()));
                break;
            }
            case FEDERATED_IDENTITY: {
                attributes.put("federatedIdentity", new AccountFederatedIdentityBean(this.session, this.realm, this.user, this.uriInfo.getBaseUri(), this.stateChecker));
                break;
            }
            case LOG: {
                attributes.put("log", new LogBean(this.events));
                break;
            }
            case SESSIONS: {
                attributes.put("sessions", new SessionsBean(this.realm, this.sessions));
                break;
            }
            case APPLICATIONS: {
                attributes.put("applications", new ApplicationsBean(this.session, this.realm, this.user));
                attributes.put("advancedMsg", new AdvancedMessageFormatterMethod(locale, messagesBundle));
                break;
            }
            case PASSWORD: {
                attributes.put("password", new PasswordBean(this.passwordSet));
                break;
            }
            case RESOURCES: {
                if (!this.realm.isUserManagedAccessAllowed()) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
                attributes.put("authorization", new AuthorizationBean(this.session, this.user, this.uriInfo));
            }
            case RESOURCE_DETAIL: {
                if (!this.realm.isUserManagedAccessAllowed()) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
                attributes.put("authorization", new AuthorizationBean(this.session, this.user, this.uriInfo));
            }
        }
        return this.processTemplate(theme, page, attributes, locale);
    }

    protected Theme getTheme() throws IOException {
        return this.session.theme().getTheme(Theme.Type.ACCOUNT);
    }

    protected Properties handleThemeResources(Theme theme, Locale locale, Map<String, Object> attributes) {
        Properties messagesBundle;
        try {
            messagesBundle = theme.getMessages(locale);
            attributes.put("msg", new MessageFormatterMethod(locale, messagesBundle));
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load messages", (Throwable)e);
            messagesBundle = new Properties();
        }
        try {
            attributes.put("properties", theme.getProperties());
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load properties", (Throwable)e);
        }
        return messagesBundle;
    }

    protected void handleMessages(Locale locale, Properties messagesBundle, Map<String, Object> attributes) {
        MessagesPerFieldBean messagesPerField = new MessagesPerFieldBean();
        if (this.messages != null) {
            MessageBean wholeMessage = new MessageBean(null, this.messageType);
            for (FormMessage message : this.messages) {
                String formattedMessageText = this.formatMessage(message, messagesBundle, locale);
                if (formattedMessageText == null) continue;
                wholeMessage.appendSummaryLine(formattedMessageText);
                messagesPerField.addMessage(message.getField(), formattedMessageText, this.messageType);
            }
            attributes.put("message", wholeMessage);
        }
        attributes.put("messagesPerField", messagesPerField);
    }

    protected Response processTemplate(Theme theme, AccountPages page, Map<String, Object> attributes, Locale locale) {
        try {
            String result = this.freeMarker.processTemplate(attributes, Templates.getTemplate(page), theme);
            Response.ResponseBuilder builder = Response.status((Response.Status)this.status).type(MediaType.TEXT_HTML_UTF_8_TYPE).language(locale).entity((Object)result);
            BrowserSecurityHeaderSetup.headers(builder, this.realm);
            return builder.build();
        }
        catch (FreeMarkerException e) {
            logger.error((Object)"Failed to process template", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public AccountProvider setPasswordSet(boolean passwordSet) {
        this.passwordSet = passwordSet;
        return this;
    }

    protected void setMessage(MessageType type, String message, Object ... parameters) {
        this.messageType = type;
        this.messages = new ArrayList<FormMessage>();
        this.messages.add(new FormMessage(null, message, parameters));
    }

    protected String formatMessage(FormMessage message, Properties messagesBundle, Locale locale) {
        if (message == null) {
            return null;
        }
        if (messagesBundle.containsKey(message.getMessage())) {
            return new MessageFormat(messagesBundle.getProperty(message.getMessage()), locale).format(message.getParameters());
        }
        return message.getMessage();
    }

    public AccountProvider setErrors(Response.Status status, List<FormMessage> messages) {
        this.status = status;
        this.messageType = MessageType.ERROR;
        this.messages = new ArrayList<FormMessage>(messages);
        return this;
    }

    public AccountProvider setError(Response.Status status, String message, Object ... parameters) {
        this.status = status;
        this.setMessage(MessageType.ERROR, message, parameters);
        return this;
    }

    public AccountProvider setSuccess(String message, Object ... parameters) {
        this.setMessage(MessageType.SUCCESS, message, parameters);
        return this;
    }

    public AccountProvider setWarning(String message, Object ... parameters) {
        this.setMessage(MessageType.WARNING, message, parameters);
        return this;
    }

    public AccountProvider setUser(UserModel user) {
        this.user = user;
        return this;
    }

    public AccountProvider setProfileFormData(MultivaluedMap<String, String> formData) {
        this.profileFormData = formData;
        return this;
    }

    public AccountProvider setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public AccountProvider setReferrer(String[] referrer) {
        this.referrer = referrer;
        return this;
    }

    public AccountProvider setEvents(List<Event> events) {
        this.events = events;
        return this;
    }

    public AccountProvider setSessions(List<UserSessionModel> sessions) {
        this.sessions = sessions;
        return this;
    }

    public AccountProvider setStateChecker(String stateChecker) {
        this.stateChecker = stateChecker;
        return this;
    }

    public AccountProvider setFeatures(boolean identityProviderEnabled, boolean eventsEnabled, boolean passwordUpdateSupported, boolean authorizationSupported) {
        this.identityProviderEnabled = identityProviderEnabled;
        this.eventsEnabled = eventsEnabled;
        this.passwordUpdateSupported = passwordUpdateSupported;
        this.authorizationSupported = authorizationSupported;
        return this;
    }

    public AccountProvider setAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
        return this;
    }

    public void close() {
    }
}

