/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.util.Collections;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.TokenCategory;
import org.keycloak.TokenVerifier;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.UserSessionCrossDCManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.services.util.MtlsHoKTokenUtil;

public class UserInfoEndpoint {
    @Context
    private HttpRequest request;
    @Context
    private HttpResponse response;
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    private final TokenManager tokenManager;
    private final AppAuthManager appAuthManager;
    private final RealmModel realm;

    public UserInfoEndpoint(TokenManager tokenManager, RealmModel realm) {
        this.realm = realm;
        this.tokenManager = tokenManager;
        this.appAuthManager = new AppAuthManager();
    }

    @Path(value="/")
    @OPTIONS
    public Response issueUserInfoPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="/")
    @GET
    @NoCache
    public Response issueUserInfoGet(@Context HttpHeaders headers) {
        String accessToken = this.appAuthManager.extractAuthorizationHeaderTokenOrReturnNull(headers);
        return this.issueUserInfo(accessToken);
    }

    @Path(value="/")
    @POST
    @NoCache
    public Response issueUserInfoPost() {
        HttpHeaders headers = this.request.getHttpHeaders();
        String accessToken = this.appAuthManager.extractAuthorizationHeaderTokenOrReturnNull(headers);
        if (accessToken == null) {
            accessToken = (String)this.request.getDecodedFormParameters().getFirst((Object)"access_token");
        }
        return this.issueUserInfo(accessToken);
    }

    private ErrorResponseException newUnauthorizedErrorResponseException(String oauthError, String errorMessage) {
        this.response.getOutputHeaders().put((Object)"WWW-Authenticate", Collections.singletonList(String.format("Bearer realm=\"%s\", error=\"%s\", error_description=\"%s\"", this.realm.getName(), oauthError, errorMessage)));
        return new ErrorResponseException(oauthError, errorMessage, Response.Status.UNAUTHORIZED);
    }

    private Response issueUserInfo(String tokenString) {
        Response.ResponseBuilder responseBuilder;
        ClientModel clientModel;
        AccessToken token;
        EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection).event(EventType.USER_INFO_REQUEST).detail("auth_method", "validate_access_token");
        if (tokenString == null) {
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_request", "Token not provided", Response.Status.BAD_REQUEST);
        }
        try {
            TokenVerifier verifier = TokenVerifier.create((String)tokenString, AccessToken.class).withDefaultChecks().realmUrl(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
            SignatureVerifierContext verifierContext = ((SignatureProvider)this.session.getProvider(SignatureProvider.class, verifier.getHeader().getAlgorithm().name())).verifier(verifier.getHeader().getKeyId());
            verifier.verifierContext(verifierContext);
            token = (AccessToken)verifier.verify().getToken();
            clientModel = this.realm.getClientByClientId(token.getIssuedFor());
            if (clientModel == null) {
                event.error("client_not_found");
                throw new ErrorResponseException("invalid_request", "Client not found", Response.Status.BAD_REQUEST);
            }
            TokenVerifier.createWithoutSignature((JsonWebToken)token).withChecks(new TokenVerifier.Predicate[]{TokenManager.NotBeforeCheck.forModel(clientModel)}).verify();
        }
        catch (VerificationException e) {
            event.error("invalid_token");
            throw this.newUnauthorizedErrorResponseException("invalid_token", "Token verification failed");
        }
        if (!clientModel.getProtocol().equals("openid-connect")) {
            event.error("invalid_client");
            throw new ErrorResponseException("invalid_client", "Wrong client protocol.", Response.Status.BAD_REQUEST);
        }
        this.session.getContext().setClient(clientModel);
        event.client(clientModel);
        if (!clientModel.isEnabled()) {
            event.error("client_disabled");
            throw new ErrorResponseException("invalid_request", "Client disabled", Response.Status.BAD_REQUEST);
        }
        UserSessionModel userSession = this.findValidSession(token, event, clientModel);
        UserModel userModel = userSession.getUser();
        if (userModel == null) {
            event.error("user_not_found");
            throw new ErrorResponseException("invalid_request", "User not found", Response.Status.BAD_REQUEST);
        }
        event.user(userModel).detail("username", userModel.getUsername());
        if (OIDCAdvancedConfigWrapper.fromClientModel(clientModel).isUseMtlsHokToken() && !MtlsHoKTokenUtil.verifyTokenBindingWithClientCertificate(token, this.request, this.session)) {
            event.error("not_allowed");
            throw this.newUnauthorizedErrorResponseException("unauthorized_client", "Client certificate missing, or its thumbprint and one in the refresh token did NOT match");
        }
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(clientModel.getId());
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionScopeParameter(clientSession, this.session);
        AccessToken userInfo = new AccessToken();
        this.tokenManager.transformUserInfoAccessToken(this.session, userInfo, userSession, clientSessionCtx);
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("sub", userModel.getId());
        claims.putAll(userInfo.getOtherClaims());
        OIDCAdvancedConfigWrapper cfg = OIDCAdvancedConfigWrapper.fromClientModel(clientModel);
        if (cfg.isUserInfoSignatureRequired()) {
            String issuerUrl = Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName());
            String audience = clientModel.getClientId();
            claims.put("iss", issuerUrl);
            claims.put("aud", audience);
            String signatureAlgorithm = this.session.tokens().signatureAlgorithm(TokenCategory.USERINFO);
            SignatureProvider signatureProvider = (SignatureProvider)this.session.getProvider(SignatureProvider.class, signatureAlgorithm);
            SignatureSignerContext signer = signatureProvider.signer();
            String signedUserInfo = new JWSBuilder().type("JWT").jsonContent(claims).sign(signer);
            responseBuilder = Response.ok((Object)signedUserInfo).header("Content-Type", (Object)"application/jwt");
            event.detail("signature_required", "true");
            event.detail("signature_algorithm", cfg.getUserInfoSignedResponseAlg().toString());
        } else {
            responseBuilder = Response.ok(claims).header("Content-Type", (Object)"application/json");
            event.detail("signature_required", "false");
        }
        event.success();
        return Cors.add(this.request, responseBuilder).auth().allowedOrigins(this.session, clientModel).build();
    }

    private UserSessionModel findValidSession(AccessToken token, EventBuilder event, ClientModel client) {
        UserSessionModel userSession = new UserSessionCrossDCManager(this.session).getUserSessionWithClient(this.realm, token.getSessionState(), false, client.getId());
        UserSessionModel offlineUserSession = null;
        if (AuthenticationManager.isSessionValid(this.realm, userSession)) {
            this.checkTokenIssuedAt(token, userSession, event);
            event.session(userSession);
            return userSession;
        }
        offlineUserSession = new UserSessionCrossDCManager(this.session).getUserSessionWithClient(this.realm, token.getSessionState(), true, client.getId());
        if (AuthenticationManager.isOfflineSessionValid(this.realm, offlineUserSession)) {
            this.checkTokenIssuedAt(token, offlineUserSession, event);
            event.session(offlineUserSession);
            return offlineUserSession;
        }
        if (userSession == null && offlineUserSession == null) {
            event.error("user_session_not_found");
            throw this.newUnauthorizedErrorResponseException("invalid_request", "User session not found or doesn't have client attached on it");
        }
        if (userSession != null) {
            event.session(userSession);
        } else {
            event.session(offlineUserSession);
        }
        event.error("session_expired");
        throw this.newUnauthorizedErrorResponseException("invalid_token", "Session expired");
    }

    private void checkTokenIssuedAt(AccessToken token, UserSessionModel userSession, EventBuilder event) throws ErrorResponseException {
        if (token.getIssuedAt() + 1 < userSession.getStarted()) {
            event.error("invalid_token");
            throw this.newUnauthorizedErrorResponseException("invalid_token", "Stale token");
        }
    }
}

