/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.google;

import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Tokeninfo;
import com.google.api.services.oauth2.model.Userinfo;
import java.util.UUID;
import org.keycloak.social.AuthCallback;
import org.keycloak.social.AuthRequest;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;

public class GoogleProvider
implements SocialProvider {
    private static final String DEFAULT_RESPONSE_TYPE = "code";
    private static final String AUTH_PATH = "https://accounts.google.com/o/oauth2/auth";
    private static final String DEFAULT_SCOPE = "https://www.googleapis.com/auth/userinfo.profile https://www.googleapis.com/auth/userinfo.email";
    private static final JacksonFactory JSON_FACTORY = new JacksonFactory();
    private static final NetHttpTransport TRANSPORT = new NetHttpTransport();

    public String getId() {
        return "google";
    }

    public AuthRequest getAuthUrl(SocialProviderConfig config) throws SocialProviderException {
        String state = UUID.randomUUID().toString();
        return AuthRequest.create((String)state, (String)AUTH_PATH).setQueryParam("client_id", config.getKey()).setQueryParam("response_type", DEFAULT_RESPONSE_TYPE).setQueryParam("scope", DEFAULT_SCOPE).setQueryParam("redirect_uri", config.getCallbackUrl()).setQueryParam("state", state).setAttribute("state", state).build();
    }

    public String getName() {
        return "Google";
    }

    public SocialUser processCallback(SocialProviderConfig config, AuthCallback callback) throws SocialProviderException {
        String code = callback.getQueryParam(DEFAULT_RESPONSE_TYPE);
        try {
            if (!callback.getQueryParam("state").equals(callback.getAttribute("state"))) {
                throw new SocialProviderException("Invalid state");
            }
            GoogleTokenResponse tokenResponse = new GoogleAuthorizationCodeTokenRequest((HttpTransport)TRANSPORT, (JsonFactory)JSON_FACTORY, config.getKey(), config.getSecret(), code, config.getCallbackUrl().toString()).execute();
            GoogleCredential credential = new GoogleCredential.Builder().setJsonFactory((JsonFactory)JSON_FACTORY).setTransport((HttpTransport)TRANSPORT).setClientSecrets(config.getKey(), config.getSecret()).build().setFromTokenResponse((TokenResponse)tokenResponse);
            Oauth2 oauth2 = new Oauth2.Builder((HttpTransport)TRANSPORT, (JsonFactory)JSON_FACTORY, (HttpRequestInitializer)credential).build();
            Tokeninfo tokenInfo = (Tokeninfo)oauth2.tokeninfo().setAccessToken(credential.getAccessToken()).execute();
            if (tokenInfo.containsKey((Object)"error")) {
                throw new SocialProviderException((String)tokenInfo.get((Object)"error"));
            }
            Userinfo userInfo = (Userinfo)oauth2.userinfo().get().execute();
            SocialUser user = new SocialUser(userInfo.getId());
            user.setUsername(userInfo.getEmail());
            user.setFirstName(userInfo.getGivenName());
            user.setLastName(userInfo.getFamilyName());
            user.setEmail(userInfo.getEmail());
            return user;
        }
        catch (Exception e) {
            throw new SocialProviderException((Throwable)e);
        }
    }

    public String getRequestIdParamName() {
        return "state";
    }
}

