/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.runtime.conf;

import java.util.Objects;
import org.kie.api.runtime.conf.SingleValueKieSessionOption;

public class PersistedSessionOption
implements SingleValueKieSessionOption {
    public static final String PROPERTY_NAME = "drools.persistedsession";
    private final long sessionId;
    private final Strategy strategy;

    private PersistedSessionOption() {
        this(-1L);
    }

    private PersistedSessionOption(long sessionId) {
        this(sessionId, Strategy.FULL);
    }

    private PersistedSessionOption(Strategy strategy) {
        this(-1L, strategy);
    }

    private PersistedSessionOption(long sessionId, Strategy strategy) {
        this.sessionId = sessionId;
        this.strategy = strategy;
    }

    public static PersistedSessionOption newSession() {
        return new PersistedSessionOption();
    }

    public static PersistedSessionOption newSession(Strategy strategy) {
        return new PersistedSessionOption(strategy);
    }

    public static PersistedSessionOption fromSession(long sessionId) {
        return new PersistedSessionOption(sessionId);
    }

    public static PersistedSessionOption fromSession(long sessionId, Strategy strategy) {
        return new PersistedSessionOption(sessionId, strategy);
    }

    @Override
    public String getPropertyName() {
        return PROPERTY_NAME;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public boolean isNewSession() {
        return this.sessionId < 0L;
    }

    public String toString() {
        return "PersistedSessionOption( " + this.sessionId + " )";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistedSessionOption that = (PersistedSessionOption)o;
        return this.sessionId == that.sessionId;
    }

    public int hashCode() {
        return Objects.hash(this.sessionId);
    }

    public static enum Strategy {
        FULL,
        STORES_ONLY;

    }
}

