/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.runtime.rule;

import java.io.PrintStream;
import java.util.List;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleRuntime;

public class ConsequenceException
extends RuntimeException {
    private RuleRuntime workingMemory;
    private Match match;

    public ConsequenceException(Throwable rootCause, RuleRuntime workingMemory, Match match) {
        super(rootCause);
        this.workingMemory = workingMemory;
        this.match = match;
    }

    @Override
    public String getMessage() {
        Rule rule;
        StringBuilder sb = new StringBuilder("Exception executing consequence for ");
        if (this.match != null && (rule = this.match.getRule()) != null) {
            String packageName = rule.getPackageName();
            String ruleName = rule.getName();
            sb.append("rule \"").append(ruleName).append("\" in ").append(packageName);
        } else {
            sb.append("rule, name unknown");
        }
        sb.append(": ").append(super.getMessage());
        return sb.toString();
    }

    public Match getMatch() {
        return this.match;
    }

    public Rule getRule() {
        return this.match.getRule();
    }

    public void printFacts() {
        this.printFacts(System.err);
    }

    public void printFacts(PrintStream pStream) {
        List<? extends FactHandle> handles = this.match.getFactHandles();
        for (FactHandle factHandle : handles) {
            Object object = this.workingMemory.getObject(factHandle);
            if (object == null) continue;
            pStream.println("   Fact " + object.getClass().getSimpleName() + ": " + object.toString());
        }
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

