/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.manager;

import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RuntimeManagerFactory {
    public RuntimeManager newSingletonRuntimeManager(RuntimeEnvironment var1);

    public RuntimeManager newSingletonRuntimeManager(RuntimeEnvironment var1, String var2);

    public RuntimeManager newPerRequestRuntimeManager(RuntimeEnvironment var1);

    public RuntimeManager newPerRequestRuntimeManager(RuntimeEnvironment var1, String var2);

    public RuntimeManager newPerProcessInstanceRuntimeManager(RuntimeEnvironment var1);

    public RuntimeManager newPerProcessInstanceRuntimeManager(RuntimeEnvironment var1, String var2);

    public static class Factory {
        private static RuntimeManagerFactory INSTANCE;
        private static Logger logger;

        public static RuntimeManagerFactory get() {
            if (INSTANCE == null) {
                throw new RuntimeException("RuntimeManagerFactory was not initialized, see previous errors");
            }
            return INSTANCE;
        }

        static {
            logger = LoggerFactory.getLogger(Factory.class);
            try {
                INSTANCE = (RuntimeManagerFactory)Class.forName("org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl").newInstance();
            }
            catch (Exception e) {
                logger.error("Unable to instance RuntimeManagerFactory due to " + e.getMessage());
            }
        }
    }
}

