/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.api.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.utils.ModelUtils;

public class CommonCompilationDTO<T extends Model>
implements CompilationDTO<T> {
    private static final long serialVersionUID = -9136538788329888191L;
    protected final String packageName;
    private final String packageCanonicalClassName;
    private final List<Field<?>> fields;
    private final TransformationDictionary transformationDictionary;
    private final T model;
    private final HasClassLoader hasClassloader;
    private final PMML pmml;
    private final PMML_MODEL pmmlModel;
    private final String simpleClassName;
    private final String targetDataFieldName;
    private final DataField targetDataField;
    private final OpType opType;

    private CommonCompilationDTO(PMML pmml, T model, HasClassLoader hasClassloader, String packageName) {
        this(pmml, model, hasClassloader, packageName, ModelUtils.getFieldsFromDataDictionaryTransformationDictionaryAndModel(pmml.getDataDictionary(), pmml.getTransformationDictionary(), model));
    }

    private CommonCompilationDTO(PMML pmml, T model, HasClassLoader hasClassloader, String packageName, List<Field<?>> fields) {
        this.packageName = packageName;
        this.pmml = pmml;
        this.transformationDictionary = pmml.getTransformationDictionary();
        this.fields = new ArrayList(fields);
        this.model = model;
        this.hasClassloader = hasClassloader;
        this.pmmlModel = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        this.simpleClassName = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        this.packageCanonicalClassName = String.format("%s.%s", this.packageName, this.simpleClassName);
        this.targetDataFieldName = ModelUtils.getTargetFieldName(fields, model).orElse(null);
        this.targetDataField = this.targetDataFieldName != null ? (DataField)fields.stream().filter(DataField.class::isInstance).map(DataField.class::cast).filter(field -> Objects.equals(this.getTargetFieldName(), field.getName().getValue())).findFirst().orElse(null) : null;
        this.opType = this.targetDataField != null ? this.targetDataField.getOpType() : null;
    }

    private CommonCompilationDTO(String packageName, PMML pmml, T model, HasClassLoader hasClassloader) {
        this(pmml, model, hasClassloader, KiePMMLModelUtils.getSanitizedPackageName((String)String.format("%s.%s", packageName, model.getModelName())));
    }

    public static <T extends Model> CommonCompilationDTO<T> fromGeneratedPackageNameAndFields(String packageName, PMML pmml, T model, HasClassLoader hasClassloader) {
        return new CommonCompilationDTO<T>(packageName, pmml, model, hasClassloader);
    }

    public static <T extends Model> CommonCompilationDTO<T> fromPackageNameAndFields(PMML pmml, T model, HasClassLoader hasClassloader, String packageName, List<Field<?>> fields) {
        return new CommonCompilationDTO<T>(pmml, model, hasClassloader, packageName, fields);
    }

    @Override
    public PMML getPmml() {
        return this.pmml;
    }

    @Override
    public TransformationDictionary getTransformationDictionary() {
        return this.transformationDictionary;
    }

    @Override
    public T getModel() {
        return this.model;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.model.getMiningSchema();
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.model.getMiningFunction();
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.model.getLocalTransformations();
    }

    @Override
    public Output getOutput() {
        return this.model.getOutput();
    }

    @Override
    public Targets getTargets() {
        return this.model.getTargets();
    }

    @Override
    public List<Field<?>> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public DataField getTargetDataField() {
        return this.targetDataField;
    }

    @Override
    public OpType getOpType() {
        return this.opType;
    }

    @Override
    public String getModelName() {
        return this.model.getModelName();
    }

    @Override
    public String getTargetFieldName() {
        return this.targetDataFieldName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getSimpleClassName() {
        return this.simpleClassName;
    }

    @Override
    public String getPackageCanonicalClassName() {
        return this.packageCanonicalClassName;
    }

    @Override
    public Class<?> compileAndLoadClass(Map<String, String> sourcesMap) {
        return this.hasClassloader.compileAndLoadClass(sourcesMap, this.packageCanonicalClassName);
    }

    @Override
    public HasClassLoader getHasClassloader() {
        return this.hasClassloader;
    }

    @Override
    public PMML_MODEL getPMML_MODEL() {
        return this.pmmlModel;
    }

    @Override
    public MINING_FUNCTION getMINING_FUNCTION() {
        return this.model.getMiningFunction() != null ? MINING_FUNCTION.byName((String)this.model.getMiningFunction().value()) : null;
    }

    public List<OutputField> getOutputFields() {
        return this.model.getOutput() != null && this.model.getOutput().hasOutputFields() ? this.model.getOutput().getOutputFields() : Collections.emptyList();
    }
}

