/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.addon;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.core.addon.TypeResolver;

public class ClassTypeResolver
implements TypeResolver {
    private String defaultPackagName;
    private Set<String> imports;
    private Set<String> implicitImports = Collections.emptySet();
    private ClassLoader classLoader;
    private Map<String, Class<?>> cachedImports = new HashMap();
    private static final Map<String, String> internalNamesMap = new HashMap<String, String>();

    public static Class<?> safeLoadClass(ClassLoader cl, String name) {
        try {
            return cl.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    public ClassTypeResolver(Set<String> imports, ClassLoader classLoader) {
        this.imports = imports;
        if (classLoader == null) {
            throw new RuntimeException("ClassTypeResolver cannot have a null parent ClassLoader");
        }
        this.classLoader = classLoader;
    }

    public ClassTypeResolver(Set<String> imports, ClassLoader rootClassLoader, String name) {
        this(imports, rootClassLoader);
        this.defaultPackagName = name;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Set<String> getImports() {
        return this.imports;
    }

    @Override
    public void addImport(String importEntry) {
        if (this.imports == Collections.EMPTY_SET) {
            this.imports = new HashSet<String>();
        }
        this.imports.add(importEntry);
    }

    @Override
    public void addImplicitImport(String importEntry) {
        if (this.implicitImports == Collections.EMPTY_SET) {
            this.implicitImports = new HashSet<String>();
        }
        this.implicitImports.add(importEntry);
    }

    private Class<?> lookupFromCache(String className) throws ClassNotFoundException {
        Class<?> clazz = this.cachedImports.get(className);
        if (clazz == Void.class) {
            throw new ClassNotFoundException("Unable to find class '" + className + "'");
        }
        return clazz;
    }

    @Override
    public void registerClass(String className, Class<?> clazz) {
        this.cachedImports.put(className, clazz);
    }

    @Override
    public Class<?> resolveType(String className) throws ClassNotFoundException {
        return this.resolveType(className, ACCEPT_ALL_CLASS_FILTER);
    }

    @Override
    public Class<?> resolveType(String className, TypeResolver.ClassFilter classFilter) throws ClassNotFoundException {
        Class<?> clazz = this.lookupFromCache(className);
        if (clazz != null && !classFilter.accept(clazz)) {
            clazz = null;
        }
        boolean isArray = false;
        StringBuilder arrayClassName = null;
        if (clazz == null && className.indexOf(91) > 0) {
            arrayClassName = new StringBuilder();
            isArray = true;
            int bracketIndex = className.indexOf(91);
            String componentName = className.substring(0, bracketIndex);
            arrayClassName.append('[');
            while ((bracketIndex = className.indexOf(91, bracketIndex + 1)) > 0) {
                arrayClassName.append('[');
            }
            className = componentName;
        }
        boolean isPrimitive = false;
        if (clazz == null && internalNamesMap.containsKey(className)) {
            clazz = Class.forName("[" + internalNamesMap.get(className), true, this.classLoader).getComponentType();
            isPrimitive = true;
        }
        if (clazz == null && (clazz = ClassTypeResolver.safeLoadClass(this.classLoader, className)) != null && !classFilter.accept(clazz)) {
            clazz = null;
        }
        if (clazz == null && (clazz = this.importClass(className, className)) != null && !classFilter.accept(clazz)) {
            clazz = null;
        }
        if (clazz == null) {
            clazz = this.getClassFromImports(className, classFilter, this.imports);
        }
        if (clazz == null) {
            clazz = this.getClassFromImports(className, classFilter, this.implicitImports);
        }
        if (clazz == null && (clazz = this.defaultClass(className)) != null && !classFilter.accept(clazz)) {
            clazz = null;
        }
        if (isArray) {
            if (isPrimitive) {
                arrayClassName.append(internalNamesMap.get(className));
            } else if (clazz != null) {
                arrayClassName.append("L").append(clazz.getName()).append(";");
            } else {
                arrayClassName.append("L").append(className).append(";");
            }
            try {
                clazz = Class.forName(arrayClassName.toString(), true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
        }
        if (clazz == null) {
            this.cachedImports.put(className, Void.class);
            throw new ClassNotFoundException("Unable to find class '" + className + "'");
        }
        this.cachedImports.put(clazz.getSimpleName(), clazz);
        return clazz;
    }

    private Class<?> getClassFromImports(String className, TypeResolver.ClassFilter classFilter, Collection<String> usedImports) {
        HashSet validClazzCandidates = new HashSet();
        for (String i : usedImports) {
            Class<?> clazz = this.importClass(i, className);
            if (clazz == null || !classFilter.accept(clazz)) continue;
            validClazzCandidates.add(clazz);
        }
        if (validClazzCandidates.size() > 1) {
            Iterator validIt = validClazzCandidates.iterator();
            while (validIt.hasNext()) {
                Class cls = (Class)validIt.next();
                if (!this.defaultPackagName.equals(cls.getPackage().getName())) continue;
                validIt.remove();
            }
        }
        if (validClazzCandidates.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (Class clazz : validClazzCandidates) {
                if (0 != sb.length()) {
                    sb.append(", ");
                }
                sb.append(clazz.getName());
            }
            throw new Error("Unable to find ambiguously defined class '" + className + "', candidates are: [" + sb.toString() + "]");
        }
        return validClazzCandidates.size() == 1 ? (Class)validClazzCandidates.iterator().next() : null;
    }

    private Class<?> importClass(String importText, String className) {
        Object qualifiedClass = null;
        Class<?> clazz = null;
        if (importText.endsWith("*")) {
            qualifiedClass = importText.substring(0, importText.indexOf(42)) + className;
        } else if (importText.endsWith("." + className)) {
            qualifiedClass = importText;
        } else if (className.indexOf(46) > 0 && importText.endsWith(className.split("\\.")[0])) {
            qualifiedClass = importText + className.substring(className.indexOf(46));
        } else if (importText.equals(className)) {
            qualifiedClass = importText;
        }
        if (qualifiedClass != null) {
            int lastIndex;
            clazz = ClassTypeResolver.safeLoadClass(this.classLoader, (String)qualifiedClass);
            while (clazz == null && (lastIndex = ((String)qualifiedClass).lastIndexOf(46)) != -1) {
                qualifiedClass = ((String)qualifiedClass).substring(0, lastIndex) + "$" + ((String)qualifiedClass).substring(lastIndex + 1);
                clazz = ClassTypeResolver.safeLoadClass(this.classLoader, (String)qualifiedClass);
            }
        }
        if (clazz != null) {
            if (this.cachedImports == Collections.EMPTY_MAP) {
                this.cachedImports = new HashMap();
            }
            this.cachedImports.put(clazz.getSimpleName(), clazz);
        }
        return clazz;
    }

    private Class<?> defaultClass(String className) {
        String qualifiedClass = "java.lang." + className;
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(qualifiedClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            if (this.cachedImports == Collections.EMPTY_MAP) {
                this.cachedImports = new HashMap();
            }
            this.cachedImports.put(className, clazz);
        }
        return clazz;
    }

    public boolean isEmpty() {
        return this.imports.isEmpty();
    }

    @Override
    public String getFullTypeName(String shortName) throws ClassNotFoundException {
        Class<?> clz = this.resolveType(shortName);
        if (clz == null) {
            throw new IllegalArgumentException("Unable to resolve the full type name for " + shortName);
        }
        return clz.getName();
    }

    public void clearImports() {
        if (this.imports != Collections.EMPTY_SET) {
            this.imports.clear();
            this.cachedImports.clear();
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    static {
        internalNamesMap.put("int", "I");
        internalNamesMap.put("boolean", "Z");
        internalNamesMap.put("float", "F");
        internalNamesMap.put("long", "J");
        internalNamesMap.put("short", "S");
        internalNamesMap.put("byte", "B");
        internalNamesMap.put("double", "D");
        internalNamesMap.put("char", "C");
    }
}

