/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.kie.services.time.Interval;

public class FinishesEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String finishesOp = "finishes";
    public static Operator FINISHES;
    public static Operator FINISHES_NOT;
    private static String[] SUPPORTED_IDS;
    private Map<String, FinishesEvaluator> cache = Collections.emptyMap();

    public FinishesEvaluatorDefinition() {
        FinishesEvaluatorDefinition.init();
    }

    static void init() {
        if (Operator.determineOperator(finishesOp, false) == null) {
            FINISHES = Operator.addOperatorToRegistry(finishesOp, false);
            FINISHES_NOT = Operator.addOperatorToRegistry(finishesOp, true);
            SUPPORTED_IDS = new String[]{finishesOp};
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        FinishesEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, FinishesEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            long[] params = TimeIntervalParser.parse(parameterText);
            eval = new FinishesEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class FinishesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long endDev;
        private String paramText;

        public FinishesEvaluator() {
            FinishesEvaluatorDefinition.init();
        }

        public FinishesEvaluator(ValueType type, boolean isNegated, long[] parameters, String paramText) {
            super(type, isNegated ? FINISHES_NOT : FINISHES);
            FinishesEvaluatorDefinition.init();
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.endDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.endDev);
            out.writeObject(this.paramText);
        }

        @Override
        public boolean isTemporal() {
            return true;
        }

        @Override
        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, Long.MAX_VALUE);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle object1, FieldValue object2) {
            throw new RuntimeException("The 'finishes' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(workingMemory, left.getObject())) {
                return false;
            }
            long distStart = ((VariableRestriction.TemporalVariableContextEntry)context).startTS - ((EventFactHandle)left).getStartTimestamp();
            long distEnd = Math.abs(((EventFactHandle)left).getEndTimestamp() - ((VariableRestriction.TemporalVariableContextEntry)context).endTS);
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(workingMemory, right.getObject())) {
                return false;
            }
            long distStart = ((EventFactHandle)right).getStartTimestamp() - ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long distEnd = Math.abs(((VariableRestriction.TemporalVariableContextEntry)context).endTS - ((EventFactHandle)right).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            if (extractor1.isNullValue(workingMemory, handle1.getObject()) || extractor2.isNullValue(workingMemory, handle2.getObject())) {
                return false;
            }
            long distStart = ((EventFactHandle)handle1).getStartTimestamp() - ((EventFactHandle)handle2).getStartTimestamp();
            long distEnd = Math.abs(((EventFactHandle)handle2).getEndTimestamp() - ((EventFactHandle)handle1).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        @Override
        public String toString() {
            return "finishes[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.endDev ^ this.endDev >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FinishesEvaluator other = (FinishesEvaluator)obj;
            return this.endDev == other.endDev;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setParameters(long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.endDev = 0L;
                return;
            } else {
                if (parameters.length != 1) throw new RuntimeException("[Finishes Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
                if (parameters[0] < 0L) throw new RuntimeException("[Finishes Evaluator]: Not possible to use negative parameter: '" + this.paramText + "'");
                this.endDev = parameters[0];
            }
        }
    }
}

