/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.base.ClassFieldAccessor;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.GenericTypeDefinition;
import org.drools.core.factmodel.traits.Alias;
import org.drools.core.util.MVELSafeHelper;
import org.drools.core.util.StringUtils;
import org.kie.api.definition.type.Annotation;
import org.kie.api.definition.type.FactField;

public class FieldDefinition
implements FactField,
Comparable<FieldDefinition> {
    private String name = null;
    private GenericTypeDefinition type;
    private boolean key = false;
    private boolean inherited = false;
    private String overriding = null;
    private int index = -1;
    private int priority = -1;
    private int declIndex = -1;
    private String initExpr = null;
    private boolean recursive = false;
    private Map<String, Object> metaData;
    private String getterName = null;
    private String setterName = null;
    private List<AnnotationDefinition> annotations;
    private ClassFieldAccessor accessor = null;

    public FieldDefinition() {
    }

    public FieldDefinition(String name, String type) {
        this(name, new GenericTypeDefinition(type));
    }

    public FieldDefinition(String name, GenericTypeDefinition type) {
        this(name, type, false);
    }

    public FieldDefinition(String name, String type, boolean key) {
        this(name, new GenericTypeDefinition(type), key);
    }

    public FieldDefinition(String name, GenericTypeDefinition type, boolean key) {
        this.name = name;
        this.type = type;
        this.key = key;
    }

    public void setReadWriteAccessor(ClassFieldAccessor accessor) {
        this.accessor = accessor;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.type = (GenericTypeDefinition)in.readObject();
        this.key = in.readBoolean();
        this.accessor = (ClassFieldAccessor)in.readObject();
        this.annotations = (List)in.readObject();
        this.inherited = in.readBoolean();
        this.overriding = (String)in.readObject();
        this.index = in.readInt();
        this.declIndex = in.readInt();
        this.priority = in.readInt();
        this.initExpr = (String)in.readObject();
        this.metaData = (Map)in.readObject();
        this.getterName = (String)in.readObject();
        this.setterName = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.type);
        out.writeBoolean(this.key);
        out.writeObject(this.accessor);
        out.writeObject(this.annotations);
        out.writeBoolean(this.inherited);
        out.writeObject(this.overriding);
        out.writeInt(this.index);
        out.writeInt(this.declIndex);
        out.writeInt(this.priority);
        out.writeObject(this.initExpr);
        out.writeObject(this.metaData);
        out.writeObject(this.getterName);
        out.writeObject(this.setterName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GenericTypeDefinition getGenericType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.getRawType();
    }

    public void setTypeName(String type) {
        this.type = new GenericTypeDefinition(type);
    }

    public Class<?> getType() {
        return this.accessor.getFieldType();
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public String getReadMethod() {
        if (this.getterName != null) {
            return this.getterName;
        }
        String prefix = "boolean".equals(this.type.getRawType()) ? "is" : "get";
        return prefix + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
    }

    public String getWriteMethod() {
        return this.setterName != null ? this.setterName : "set" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
    }

    public boolean equals(Object o) {
        return o != null && this.getName().equals(((FieldDefinition)o).getName());
    }

    public ClassFieldAccessor getFieldAccessor() {
        return this.accessor;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void setValue(Object bean, Object value) {
        this.accessor.setValue(bean, value);
    }

    public Object getValue(Object bean) {
        return this.accessor.getValue(bean);
    }

    public Object get(Object bean) {
        return this.accessor.getValue(bean);
    }

    public void set(Object bean, Object value) {
        this.accessor.setValue(bean, value);
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getDeclIndex() {
        return this.declIndex;
    }

    public void setDeclIndex(int declIndex) {
        this.declIndex = declIndex;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getInitExpr() {
        return this.initExpr;
    }

    public void setInitExpr(String initExpr) {
        this.initExpr = initExpr;
    }

    @Override
    public int compareTo(FieldDefinition other) {
        return this.priority - other.priority;
    }

    public void addAnnotation(AnnotationDefinition annotationDefinition) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationDefinition>();
        }
        this.annotations.add(annotationDefinition);
    }

    public List<AnnotationDefinition> getAnnotations() {
        return this.annotations;
    }

    public List<Annotation> getFieldAnnotations() {
        return Collections.unmodifiableList(new ArrayList<AnnotationDefinition>(this.annotations));
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void addMetaData(String key, Object value) {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, Object>();
        }
        this.metaData.put(key, value);
    }

    public String getDefaultValueAsString() {
        return MVELSafeHelper.getEvaluator().eval(this.initExpr, String.class);
    }

    public Boolean getDefaultValueAsBoolean() {
        if (StringUtils.isEmpty(this.initExpr)) {
            return false;
        }
        if ("true".equalsIgnoreCase(this.initExpr)) {
            return true;
        }
        if ("false".equalsIgnoreCase(this.initExpr)) {
            return false;
        }
        return MVELSafeHelper.getEvaluator().eval(this.initExpr, Boolean.class);
    }

    public Byte getDefaultValueAsByte() {
        try {
            return this.initExpr == null ? (byte)0 : Byte.parseByte(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? Byte.valueOf((byte)0) : MVELSafeHelper.getEvaluator().eval(this.initExpr, Byte.class);
        }
    }

    public Character getDefaultValueAsChar() {
        if (StringUtils.isEmpty(this.initExpr)) {
            return Character.valueOf('\u0000');
        }
        if (this.initExpr.length() == 1) {
            return Character.valueOf(this.initExpr.charAt(0));
        }
        return MVELSafeHelper.getEvaluator().eval(this.initExpr, Character.class);
    }

    public Double getDefaultValueAsDouble() {
        try {
            return this.initExpr == null ? 0.0 : Double.parseDouble(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? Double.valueOf(0.0) : MVELSafeHelper.getEvaluator().eval(this.initExpr, Double.class);
        }
    }

    public Float getDefaultValueAsFloat() {
        try {
            return Float.valueOf(this.initExpr == null ? 0.0f : Float.parseFloat(this.initExpr));
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? Float.valueOf(0.0f) : MVELSafeHelper.getEvaluator().eval(this.initExpr, Float.class);
        }
    }

    public Integer getDefaultValueAsInt() {
        try {
            return this.initExpr == null ? 0 : Integer.parseInt(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? Integer.valueOf(0) : MVELSafeHelper.getEvaluator().eval(this.initExpr, Integer.class);
        }
    }

    public Long getDefaultValueAsLong() {
        try {
            return this.initExpr == null ? 0L : Long.parseLong(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? Long.valueOf(0L) : MVELSafeHelper.getEvaluator().eval(this.initExpr, Long.class);
        }
    }

    public Short getDefaultValueAsShort() {
        try {
            return this.initExpr == null ? (short)0 : Short.parseShort(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? Short.valueOf((short)0) : MVELSafeHelper.getEvaluator().eval(this.initExpr, Short.class);
        }
    }

    public boolean getDefaultValueAs_boolean() {
        if (StringUtils.isEmpty(this.initExpr)) {
            return false;
        }
        if ("true".equalsIgnoreCase(this.initExpr)) {
            return true;
        }
        if ("false".equalsIgnoreCase(this.initExpr)) {
            return false;
        }
        return MVELSafeHelper.getEvaluator().eval(this.initExpr, Boolean.class);
    }

    public byte getDefaultValueAs_byte() {
        try {
            return this.initExpr == null ? (byte)0 : Byte.parseByte(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? (byte)0 : MVELSafeHelper.getEvaluator().eval(this.initExpr, Byte.class);
        }
    }

    public char getDefaultValueAs_char() {
        if (StringUtils.isEmpty(this.initExpr)) {
            return '\u0000';
        }
        if (this.initExpr.length() == 1) {
            return this.initExpr.charAt(0);
        }
        return MVELSafeHelper.getEvaluator().eval(this.initExpr, Character.class).charValue();
    }

    public double getDefaultValueAs_double() {
        try {
            return this.initExpr == null ? 0.0 : Double.parseDouble(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? 0.0 : MVELSafeHelper.getEvaluator().eval(this.initExpr, Double.class);
        }
    }

    public float getDefaultValueAs_float() {
        try {
            return this.initExpr == null ? 0.0f : Float.parseFloat(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? 0.0f : MVELSafeHelper.getEvaluator().eval(this.initExpr, Float.class).floatValue();
        }
    }

    public int getDefaultValueAs_int() {
        try {
            return this.initExpr == null ? 0 : Integer.parseInt(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? 0 : MVELSafeHelper.getEvaluator().eval(this.initExpr, Integer.class);
        }
    }

    public long getDefaultValueAs_long() {
        try {
            return this.initExpr == null ? 0L : Long.parseLong(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? 0L : MVELSafeHelper.getEvaluator().eval(this.initExpr, Long.class);
        }
    }

    public short getDefaultValueAs_short() {
        try {
            return this.initExpr == null ? (short)0 : Short.parseShort(this.initExpr);
        }
        catch (NumberFormatException nfe) {
            return StringUtils.isEmpty(this.initExpr) ? (short)0 : MVELSafeHelper.getEvaluator().eval(this.initExpr, Short.class);
        }
    }

    public String toString() {
        return "FieldDefinition{name='" + this.name + "', type='" + this.type + "', key=" + this.key + ", inherited=" + this.inherited + ", index=" + this.index + ", initExpr='" + this.initExpr + "', annotations=" + this.annotations + ", accessor=" + this.accessor + "}";
    }

    public String resolveAlias() {
        if (this.getAnnotations() != null) {
            for (AnnotationDefinition def : this.getAnnotations()) {
                if (!def.getName().equals(Alias.class.getName())) continue;
                String alias = (String)def.getValues().get("value").getValue();
                return alias;
            }
        }
        return this.getName();
    }

    public String getAlias() {
        if (this.getAnnotations() != null) {
            for (AnnotationDefinition def : this.getAnnotations()) {
                if (!def.getName().equals(Alias.class.getName())) continue;
                return (String)def.getValues().get("value").getValue();
            }
        }
        return this.getName();
    }

    public boolean hasAlias() {
        if (this.getAnnotations() == null) {
            return false;
        }
        for (AnnotationDefinition def : this.getAnnotations()) {
            if (!def.getName().equals(Alias.class.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean hasOverride() {
        return this.overriding != null;
    }

    public String getOverriding() {
        return this.overriding;
    }

    public void setOverriding(String overriding) {
        this.overriding = overriding;
    }

    public String getGetterName() {
        return this.getterName;
    }

    public void setGetterName(String getterName) {
        this.getterName = getterName;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public void setSetterName(String setterName) {
        this.setterName = setterName;
    }
}

