/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.core.factmodel.BuildUtils;

public class GenericTypeDefinition
implements Serializable {
    private final String rawType;
    private final List<GenericTypeDefinition> genericTypes;

    public GenericTypeDefinition(String rawType) {
        this(rawType, null);
    }

    private GenericTypeDefinition(String rawType, List<GenericTypeDefinition> genericTypes) {
        this.rawType = rawType;
        this.genericTypes = genericTypes;
    }

    public static GenericTypeDefinition parseType(String type, Function<String, String> resolver) {
        int genericsStart = type.indexOf(60);
        if (genericsStart < 0) {
            String resolvedType = resolver.apply(type);
            return resolvedType != null ? new GenericTypeDefinition(resolvedType, null) : null;
        }
        ArrayList<GenericTypeDefinition> genericTypes = new ArrayList<GenericTypeDefinition>();
        String rawType = type.substring(0, genericsStart).trim();
        String resolvedRawType = resolver.apply(rawType);
        if (resolvedRawType == null) {
            return null;
        }
        String generics = type.substring(genericsStart + 1, type.length() - 1);
        for (String gen : generics.split("\\,")) {
            GenericTypeDefinition genType = GenericTypeDefinition.parseType(gen, resolver);
            if (genType == null) {
                return null;
            }
            genericTypes.add(genType);
        }
        return new GenericTypeDefinition(resolvedRawType, genericTypes);
    }

    public String getRawType() {
        return this.rawType;
    }

    public String getDescriptor() {
        return BuildUtils.getTypeDescriptor(this.rawType);
    }

    public boolean hasGenerics() {
        return this.genericTypes != null;
    }

    public String getSignature() {
        String descriptor = this.getDescriptor();
        if (this.genericTypes == null) {
            return descriptor;
        }
        return descriptor.substring(0, descriptor.length() - 1) + "<" + this.genericTypes.stream().map(GenericTypeDefinition::getSignature).collect(Collectors.joining()) + ">;";
    }

    public GenericTypeDefinition map(Function<String, String> transformer) {
        return new GenericTypeDefinition(transformer.apply(this.rawType), this.genericTypes != null ? this.genericTypes.stream().map((? super T t) -> t.map(transformer)).collect(Collectors.toList()) : null);
    }

    public String toString() {
        return this.rawType + (String)(this.genericTypes == null ? "" : "<" + this.genericTypes.stream().map(GenericTypeDefinition::toString).collect(Collectors.joining(", ")) + ">");
    }
}

