/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.io.Serializable;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.BuildUtils;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.DefaultBeanClassBuilder;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.GeneratedFact;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.TraitClassBuilder;
import org.drools.core.rule.builder.dialect.asm.ClassGenerator;
import org.mvel2.asm.AnnotationVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

public class TraitClassBuilderImpl
implements TraitClassBuilder,
Serializable {
    @Override
    public byte[] buildClass(ClassDefinition classDef, ClassLoader classLoader) {
        String[] tmp;
        this.init(classDef);
        String cName = BuildUtils.getInternalType(classDef.getClassName());
        String genericTypes = BuildUtils.getGenericTypes(classDef.getInterfaces());
        String superType = Type.getInternalName(Object.class);
        String[] intfaces = null;
        if (Object.class.getName().equals(classDef.getSuperClass())) {
            tmp = BuildUtils.getInternalTypes(classDef.getInterfaces());
            intfaces = new String[tmp.length + 2];
            System.arraycopy(tmp, 0, intfaces, 0, tmp.length);
            intfaces[tmp.length] = Type.getInternalName(Serializable.class);
            intfaces[tmp.length + 1] = Type.getInternalName(GeneratedFact.class);
        } else {
            tmp = BuildUtils.getInternalTypes(classDef.getInterfaces());
            intfaces = new String[tmp.length + 3];
            System.arraycopy(tmp, 0, intfaces, 0, tmp.length);
            intfaces[tmp.length] = BuildUtils.getInternalType(classDef.getSuperClass());
            intfaces[tmp.length + 1] = Type.getInternalName(Serializable.class);
            intfaces[tmp.length + 2] = Type.getInternalName(GeneratedFact.class);
        }
        ClassWriter cw = ClassGenerator.createClassWriter(classLoader, 1537, cName, genericTypes, superType, intfaces);
        if (classDef.getDefinedClass() == null || classDef.getDefinedClass().getAnnotation(Trait.class) == null) {
            AnnotationVisitor av0 = cw.visitAnnotation(Type.getDescriptor(Trait.class), true);
            for (AnnotationDefinition adef : classDef.getAnnotations()) {
                if (!Trait.class.getName().equals(adef.getName())) continue;
                DefaultBeanClassBuilder.addAnnotationAttribute(adef, av0);
                break;
            }
            av0.visitEnd();
        }
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            this.buildField(cw, field);
        }
        this.finalizeCreation(classDef);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected void init(ClassDefinition classDef) {
    }

    private void buildField(ClassWriter cw, FieldDefinition field) {
        Object name = field.getName();
        name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        String type = field.getTypeName();
        this.buildGetter(cw, field, (String)name, type, null);
        this.buildSetter(cw, field, (String)name, type, null);
    }

    protected void buildSetter(ClassWriter cw, FieldDefinition field, String name, String type, String generic) {
        MethodVisitor mv = cw.visitMethod(1025, BuildUtils.setterName(name), "(" + BuildUtils.getTypeDescriptor(type) + ")V", generic == null ? null : "(" + BuildUtils.getTypeDescriptor(type).replace(";", "<" + BuildUtils.getTypeDescriptor(generic) + ">;") + ")V", null);
        mv.visitEnd();
    }

    protected void buildGetter(ClassWriter cw, FieldDefinition field, String name, String type, String generic) {
        name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        MethodVisitor mv = cw.visitMethod(1025, BuildUtils.getterName((String)name, type), "()" + BuildUtils.getTypeDescriptor(type), generic == null ? null : "()" + BuildUtils.getTypeDescriptor(type).replace(";", "<" + BuildUtils.getTypeDescriptor(generic) + ">;"), null);
        mv.visitEnd();
    }

    protected void finalizeCreation(ClassDefinition trait) {
    }
}

