/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.Declaration;
import org.drools.core.util.MVELSafeHelper;
import org.kie.api.runtime.rule.Variable;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;

public interface QueryArgument
extends Externalizable {
    public static final Var VAR = new Var();
    public static final Null NULL = new Null();

    public QueryArgument normalize(ClassLoader var1);

    public Object getValue(InternalWorkingMemory var1, LeftTuple var2);

    public static class Null
    implements QueryArgument {
        @Override
        public Object getValue(InternalWorkingMemory wm, LeftTuple leftTuple) {
            return null;
        }

        @Override
        public QueryArgument normalize(ClassLoader classLoader) {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }

    public static class Var
    implements QueryArgument {
        @Override
        public Object getValue(InternalWorkingMemory wm, LeftTuple leftTuple) {
            return Variable.v;
        }

        @Override
        public QueryArgument normalize(ClassLoader classLoader) {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }

    public static class Literal
    implements QueryArgument {
        private Object value;

        public Literal() {
        }

        public Literal(Object value) {
            this.value = value;
        }

        @Override
        public Object getValue(InternalWorkingMemory wm, LeftTuple leftTuple) {
            return this.value;
        }

        @Override
        public QueryArgument normalize(ClassLoader classLoader) {
            try {
                return this.value instanceof Class ? new Literal(classLoader.loadClass(((Class)this.value).getName())) : this;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.value);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readObject();
        }
    }

    public static class Expression
    implements QueryArgument {
        private List<Declaration> declarations;
        private String expression;
        private ParserContext parserContext;
        private transient Class<?> argumentClass;
        private transient Serializable mvelExpr;

        public Expression() {
        }

        public Expression(List<Declaration> declarations, String expression, ParserContext parserContext) {
            this.declarations = declarations;
            this.expression = expression;
            this.parserContext = parserContext;
            this.init();
        }

        private void init() {
            HashMap inputs = new HashMap();
            for (Declaration d : this.declarations) {
                inputs.put(d.getBindingName(), d.getDeclarationClass());
            }
            this.parserContext.setInputs(inputs);
            this.argumentClass = MVEL.analyze((String)this.expression, (ParserContext)this.parserContext);
            this.mvelExpr = MVEL.compileExpression((String)this.expression, (ParserContext)this.parserContext);
        }

        @Override
        public Object getValue(InternalWorkingMemory wm, LeftTuple leftTuple) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            for (Declaration d : this.declarations) {
                vars.put(d.getBindingName(), Declr.evaluateDeclaration(wm, leftTuple, d));
            }
            return MVELSafeHelper.getEvaluator().executeExpression((Object)this.mvelExpr, vars);
        }

        @Override
        public QueryArgument normalize(ClassLoader classLoader) {
            this.parserContext.getParserConfiguration().setClassLoader(classLoader);
            return new Expression(this.declarations, this.expression, this.parserContext);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.declarations);
            out.writeObject(this.expression);
            out.writeObject(this.parserContext);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.declarations = (List)in.readObject();
            this.expression = (String)in.readObject();
            this.parserContext = (ParserContext)in.readObject();
            ParserConfiguration newConf = new ParserConfiguration();
            newConf.setImports(this.parserContext.getParserConfiguration().getImports());
            newConf.setPackageImports(this.parserContext.getParserConfiguration().getPackageImports());
            this.parserContext = new ParserContext(newConf);
            this.parserContext.setInputs(this.parserContext.getInputs());
            this.parserContext.setVariables(this.parserContext.getVariables());
            this.init();
        }
    }

    public static class Declr
    implements QueryArgument {
        private Declaration declaration;

        public Declr() {
        }

        public Declr(Declaration declaration) {
            this.declaration = declaration;
        }

        @Override
        public Object getValue(InternalWorkingMemory wm, LeftTuple leftTuple) {
            return Declr.evaluateDeclaration(wm, leftTuple, this.declaration);
        }

        static Object evaluateDeclaration(InternalWorkingMemory wm, LeftTuple leftTuple, Declaration declaration) {
            Object tupleObject = leftTuple.get(declaration).getObject();
            if (tupleObject instanceof DroolsQuery && declaration.getExtractor().getIndex() >= 0 && ((DroolsQuery)tupleObject).getVariables()[declaration.getExtractor().getIndex()] != null) {
                return Variable.v;
            }
            return declaration.getValue(wm, tupleObject);
        }

        @Override
        public QueryArgument normalize(ClassLoader classLoader) {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.declaration);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.declaration = (Declaration)in.readObject();
        }

        public Declaration getDeclaration() {
            return this.declaration;
        }

        public Class<?> getArgumentClass() {
            return this.declaration.getDeclarationClass();
        }
    }
}

