/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time;

import org.drools.core.SessionConfiguration;
import org.kie.services.time.TimerService;

public class TimerServiceFactory {
    public static TimerService getTimerService(SessionConfiguration config) {
        TimerService service;
        switch (config.getClockType()) {
            case REALTIME_CLOCK: {
                service = config.newTimerService();
                break;
            }
            case PSEUDO_CLOCK: {
                service = (TimerService)config.getClockType().createInstance();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported clock type: " + config.getClockType());
            }
        }
        service.setTimerJobFactoryManager(config.getTimerJobFactoryManager());
        return service;
    }
}

