/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.time.SessionPseudoClock;
import org.kie.services.time.InternalSchedulerService;
import org.kie.services.time.Job;
import org.kie.services.time.JobContext;
import org.kie.services.time.JobHandle;
import org.kie.services.time.TimerService;
import org.kie.services.time.Trigger;
import org.kie.services.time.impl.DefaultJobHandle;
import org.kie.services.time.impl.DefaultTimerJobFactoryManager;
import org.kie.services.time.impl.DefaultTimerJobInstance;
import org.kie.services.time.impl.TimerJobFactoryManager;
import org.kie.services.time.impl.TimerJobInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoClockScheduler
implements TimerService,
SessionPseudoClock,
Externalizable,
InternalSchedulerService {
    private Logger logger = LoggerFactory.getLogger(PseudoClockScheduler.class);
    private AtomicLong timer;
    private PriorityBlockingQueue<DefaultTimerJobInstance> queue;
    private transient InternalWorkingMemory session;
    private TimerJobFactoryManager jobFactoryManager = DefaultTimerJobFactoryManager.instance;
    private AtomicLong idCounter = new AtomicLong();

    public PseudoClockScheduler() {
        this(null);
    }

    public PseudoClockScheduler(InternalWorkingMemory session) {
        this.timer = new AtomicLong(0L);
        this.queue = new PriorityBlockingQueue();
        this.session = session;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.timer = new AtomicLong(in.readLong());
        PriorityBlockingQueue tmp = (PriorityBlockingQueue)in.readObject();
        if (tmp != null) {
            this.queue = tmp;
        }
        this.session = ((DroolsObjectInputStream)in).getWorkingMemory();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.timer.get());
        out.writeObject(this.queue.isEmpty() ? null : this.queue);
    }

    public void setTimerJobFactoryManager(TimerJobFactoryManager timerJobFactoryManager) {
        this.jobFactoryManager = timerJobFactoryManager;
    }

    public TimerJobFactoryManager getTimerJobFactoryManager() {
        return this.jobFactoryManager;
    }

    public long getCurrentTime() {
        return this.timer.get();
    }

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        Date date = trigger.hasNextFireTime();
        if (date != null) {
            DefaultJobHandle jobHandle = new DefaultJobHandle(this.idCounter.getAndIncrement());
            TimerJobInstance jobInstance = this.jobFactoryManager.createTimerJobInstance(job, ctx, trigger, (JobHandle)jobHandle, (InternalSchedulerService)this);
            jobHandle.setTimerJobInstance(jobInstance);
            this.internalSchedule(jobInstance);
            return jobHandle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalSchedule(TimerJobInstance timerJobInstance) {
        this.jobFactoryManager.addTimerJobInstance(timerJobInstance);
        PriorityBlockingQueue<DefaultTimerJobInstance> priorityBlockingQueue = this.queue;
        synchronized (priorityBlockingQueue) {
            this.queue.add((DefaultTimerJobInstance)timerJobInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJob(JobHandle jobHandle) {
        jobHandle.setCancel(true);
        this.jobFactoryManager.removeTimerJobInstance(((DefaultJobHandle)jobHandle).getTimerJobInstance());
        PriorityBlockingQueue<DefaultTimerJobInstance> priorityBlockingQueue = this.queue;
        synchronized (priorityBlockingQueue) {
            return this.queue.remove(((DefaultJobHandle)jobHandle).getTimerJobInstance());
        }
    }

    public long advanceTime(long amount, TimeUnit unit) {
        return this.runCallBacksAndIncreaseTimer(unit.toMillis(amount));
    }

    public void setStartupTime(long i) {
        this.timer.set(i);
    }

    public synchronized InternalWorkingMemory getSession() {
        return this.session;
    }

    public synchronized void setSession(InternalWorkingMemory session) {
        this.session = session;
    }

    public void reset() {
        this.idCounter.set(0L);
        this.timer.set(0L);
        this.queue.clear();
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long runCallBacksAndIncreaseTimer(long increase) {
        long fireTime;
        long endTime = this.timer.get() + increase;
        TimerJobInstance item = (TimerJobInstance)this.queue.peek();
        while (item != null && item.getTrigger().hasNextFireTime() != null && (fireTime = item.getTrigger().hasNextFireTime().getTime()) <= endTime) {
            PriorityBlockingQueue<DefaultTimerJobInstance> priorityBlockingQueue = this.queue;
            synchronized (priorityBlockingQueue) {
                this.queue.remove(item);
            }
            if (item.getJobHandle().isCancel()) continue;
            try {
                this.timer.getAndSet(fireTime);
                ((Callable)item).call();
            }
            catch (Exception e) {
                this.logger.error("Exception running callbacks: ", (Throwable)e);
            }
            priorityBlockingQueue = this.queue;
            synchronized (priorityBlockingQueue) {
                item = (TimerJobInstance)this.queue.peek();
            }
        }
        this.timer.set(endTime);
        return this.timer.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeToNextJob() {
        PriorityBlockingQueue<DefaultTimerJobInstance> priorityBlockingQueue = this.queue;
        synchronized (priorityBlockingQueue) {
            TimerJobInstance item = (TimerJobInstance)this.queue.peek();
            return item != null ? item.getTrigger().hasNextFireTime().getTime() - this.timer.get() : -1L;
        }
    }

    public Collection<TimerJobInstance> getTimerJobInstances(long id) {
        return this.jobFactoryManager.getTimerJobInstances();
    }
}

