/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.index.TupleList;

public class TupleRBTree<K extends Comparable<? super K>> {
    public static final boolean VERIFY_RBTREE = false;
    private static final int INDENT_STEP = 4;
    public Node<K> root;
    public Node<K> nullNode;

    public void verifyProperties() {
    }

    private static void verifyProperty1(Node<?> n) {
        assert (TupleRBTree.nodeColor(n) == Color.RED || TupleRBTree.nodeColor(n) == Color.BLACK);
        if (n == null) {
            return;
        }
        TupleRBTree.verifyProperty1(n.left);
        TupleRBTree.verifyProperty1(n.right);
    }

    private static void verifyProperty2(Node<?> root) {
        assert (TupleRBTree.nodeColor(root) == Color.BLACK);
    }

    private static Color nodeColor(Node<?> n) {
        return n == null ? Color.BLACK : n.color;
    }

    private static void verifyProperty4(Node<?> n) {
        if (TupleRBTree.nodeColor(n) == Color.RED) {
            assert (TupleRBTree.nodeColor(n.left) == Color.BLACK);
            assert (TupleRBTree.nodeColor(n.right) == Color.BLACK);
            assert (TupleRBTree.nodeColor(n.parent) == Color.BLACK);
        }
        if (n == null) {
            return;
        }
        TupleRBTree.verifyProperty4(n.left);
        TupleRBTree.verifyProperty4(n.right);
    }

    private static void verifyProperty5(Node<?> root) {
        TupleRBTree.verifyProperty5Helper(root, 0, -1);
    }

    private static int verifyProperty5Helper(Node<?> n, int blackCount, int pathBlackCount) {
        if (TupleRBTree.nodeColor(n) == Color.BLACK) {
            ++blackCount;
        }
        if (n == null) {
            if (pathBlackCount == -1) {
                pathBlackCount = blackCount;
            } else assert (blackCount == pathBlackCount);
            return pathBlackCount;
        }
        pathBlackCount = TupleRBTree.verifyProperty5Helper(n.left, blackCount, pathBlackCount);
        pathBlackCount = TupleRBTree.verifyProperty5Helper(n.right, blackCount, pathBlackCount);
        return pathBlackCount;
    }

    public Node<K> lookup(K key) {
        if (key == null) {
            return this.nullNode;
        }
        Node<K> n = this.root;
        while (n != null) {
            int compResult = key.compareTo(n.key);
            if (compResult == 0) {
                return n;
            }
            if (compResult < 0) {
                n = n.left;
                continue;
            }
            n = n.right;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public Node<K> first() {
        if (this.root == null) {
            return null;
        }
        Node<K> n = this.root;
        while (n.left != null) {
            n = n.left;
        }
        return n;
    }

    public Node<K> last() {
        if (this.root == null) {
            return null;
        }
        Node<K> n = this.root;
        while (n.right != null) {
            n = n.right;
        }
        return n;
    }

    public FastIterator fastIterator() {
        return this.root == null ? FastIterator.EMPTY : new RangeFastIterator<K>(this.first(), null);
    }

    public String toString() {
        FastIterator iterator = this.fastIterator();
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        Entry entry = iterator.next(null);
        while (entry != null) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry);
            entry = iterator.next(null);
        }
        sb.append("]");
        return sb.toString();
    }

    public FastIterator range(K lowerBound, boolean testLowerEqual, K upperBound, boolean testUpperEqual) {
        Node<K> lowerNearest = this.findNearestNode(lowerBound, testLowerEqual, Boundary.LOWER);
        Node<K> upperNearest = this.findNearestNode(upperBound, testUpperEqual, Boundary.UPPER);
        if (lowerNearest == null || upperNearest == null) {
            return FastIterator.EMPTY;
        }
        if (lowerNearest.key.compareTo(upperNearest.key) > 0) {
            upperNearest = lowerNearest;
        }
        return new RangeFastIterator<K>(lowerNearest, upperNearest);
    }

    public void rangeUperBounded(K upperBound, boolean testUpperEqual) {
        Node<K> upperNearest = this.findNearestNode(upperBound, testUpperEqual, Boundary.UPPER);
    }

    public void rangeLowerBounded(K upperBound, boolean testUpperEqual) {
        Node<K> upperNearest = this.findNearestNode(upperBound, testUpperEqual, Boundary.UPPER);
    }

    public Node<K> findNearestNode(K key, boolean allowEqual, Boundary boundary) {
        if (key == null) {
            return allowEqual ? this.nullNode : null;
        }
        Node<K> nearest = null;
        Node<K> n = this.root;
        while (n != null) {
            int compResult = key.compareTo(n.key);
            if (allowEqual && compResult == 0) {
                return n;
            }
            boolean accepted = this.acceptNode(compResult, boundary);
            if (this.acceptNode(compResult, boundary) && (nearest == null || this.acceptNode(n.key.compareTo(nearest.key), boundary))) {
                nearest = n;
            }
            if (compResult == 0) {
                n = boundary == Boundary.LOWER ? n.right : n.left;
                continue;
            }
            n = accepted ^ boundary == Boundary.LOWER ? n.right : n.left;
        }
        return nearest;
    }

    private boolean acceptNode(int compResult, Boundary boundary) {
        return compResult != 0 && compResult > 0 ^ boundary == Boundary.LOWER;
    }

    private void rotateLeft(Node<K> n) {
        Node r = n.right;
        this.replaceNode(n, r);
        n.right = r.left;
        if (r.left != null) {
            r.left.parent = n;
        }
        r.left = n;
        n.parent = r;
    }

    private void rotateRight(Node<K> n) {
        Node l = n.left;
        this.replaceNode(n, l);
        n.left = l.right;
        if (l.right != null) {
            l.right.parent = n;
        }
        l.right = n;
        n.parent = l;
    }

    private void replaceNode(Node<K> oldn, Node<K> newn) {
        if (oldn.parent == null) {
            this.root = newn;
        } else if (oldn == oldn.parent.left) {
            oldn.parent.left = newn;
        } else {
            oldn.parent.right = newn;
        }
        if (newn != null) {
            newn.parent = oldn.parent;
        }
    }

    public Node<K> insert(K key) {
        Node<K> insertedNode;
        if (key == null) {
            if (this.nullNode == null) {
                this.nullNode = new Node<K>(key);
            }
            return this.nullNode;
        }
        if (this.root == null) {
            insertedNode = new Node<K>(key);
            this.root = insertedNode;
        } else {
            Node<K> n = this.root;
            while (true) {
                int compResult;
                if ((compResult = key.compareTo(n.key)) == 0) {
                    return n;
                }
                if (compResult < 0) {
                    if (n.left == null) {
                        insertedNode = new Node<K>(key);
                        n.left = insertedNode;
                        break;
                    }
                    n = n.left;
                    continue;
                }
                if (n.right == null) {
                    insertedNode = new Node<K>(key);
                    n.right = insertedNode;
                    break;
                }
                n = n.right;
            }
            insertedNode.parent = n;
        }
        this.insertCase1(insertedNode);
        return insertedNode;
    }

    private void insertCase1(Node<K> n) {
        if (n.parent == null) {
            n.color = Color.BLACK;
        } else {
            this.insertCase2(n);
        }
    }

    private void insertCase2(Node<K> n) {
        if (TupleRBTree.nodeColor(n.parent) == Color.BLACK) {
            return;
        }
        this.insertCase3(n);
    }

    void insertCase3(Node<K> n) {
        if (TupleRBTree.nodeColor(n.uncle()) == Color.RED) {
            n.parent.color = Color.BLACK;
            n.uncle().color = Color.BLACK;
            n.grandparent().color = Color.RED;
            this.insertCase1(n.grandparent());
        } else {
            this.insertCase4(n);
        }
    }

    void insertCase4(Node<K> n) {
        if (n == n.parent.right && n.parent == n.grandparent().left) {
            this.rotateLeft(n.parent);
            n = n.left;
        } else if (n == n.parent.left && n.parent == n.grandparent().right) {
            this.rotateRight(n.parent);
            n = n.right;
        }
        this.insertCase5(n);
    }

    void insertCase5(Node<K> n) {
        n.parent.color = Color.BLACK;
        n.grandparent().color = Color.RED;
        if (n == n.parent.left && n.parent == n.grandparent().left) {
            this.rotateRight(n.grandparent());
        } else {
            this.rotateLeft(n.grandparent());
        }
    }

    public void delete(K key) {
        Node child;
        Node<K> n = this.lookup(key);
        if (n == null) {
            return;
        }
        if (n.left != null && n.right != null) {
            Node<K> pred = TupleRBTree.maximumNode(n.left);
            pred.copyStateInto(n);
            n = pred;
        }
        Node node = child = n.right == null ? n.left : n.right;
        if (TupleRBTree.nodeColor(n) == Color.BLACK) {
            n.color = TupleRBTree.nodeColor(child);
            this.deleteCase1(n);
        }
        this.replaceNode(n, child);
        if (TupleRBTree.nodeColor(this.root) == Color.RED) {
            this.root.color = Color.BLACK;
        }
        if (TupleRBTree.nodeColor(this.root) == Color.RED) {
            this.root.color = Color.BLACK;
        }
    }

    private static <K extends Comparable<? super K>, V> Node<K> maximumNode(Node<K> n) {
        while (n.right != null) {
            n = n.right;
        }
        return n;
    }

    private void deleteCase1(Node<K> n) {
        if (n.parent == null) {
            return;
        }
        this.deleteCase2(n);
    }

    private void deleteCase2(Node<K> n) {
        if (TupleRBTree.nodeColor(n.sibling()) == Color.RED) {
            n.parent.color = Color.RED;
            n.sibling().color = Color.BLACK;
            if (n == n.parent.left) {
                this.rotateLeft(n.parent);
            } else {
                this.rotateRight(n.parent);
            }
        }
        this.deleteCase3(n);
    }

    private void deleteCase3(Node<K> n) {
        if (TupleRBTree.nodeColor(n.parent) == Color.BLACK && TupleRBTree.nodeColor(n.sibling()) == Color.BLACK && TupleRBTree.nodeColor(n.sibling().left) == Color.BLACK && TupleRBTree.nodeColor(n.sibling().right) == Color.BLACK) {
            n.sibling().color = Color.RED;
            this.deleteCase1(n.parent);
        } else {
            this.deleteCase4(n);
        }
    }

    private void deleteCase4(Node<K> n) {
        if (TupleRBTree.nodeColor(n.parent) == Color.RED && TupleRBTree.nodeColor(n.sibling()) == Color.BLACK && TupleRBTree.nodeColor(n.sibling().left) == Color.BLACK && TupleRBTree.nodeColor(n.sibling().right) == Color.BLACK) {
            n.sibling().color = Color.RED;
            n.parent.color = Color.BLACK;
        } else {
            this.deleteCase5(n);
        }
    }

    private void deleteCase5(Node<K> n) {
        if (n == n.parent.left && TupleRBTree.nodeColor(n.sibling()) == Color.BLACK && TupleRBTree.nodeColor(n.sibling().left) == Color.RED && TupleRBTree.nodeColor(n.sibling().right) == Color.BLACK) {
            n.sibling().color = Color.RED;
            n.sibling().left.color = Color.BLACK;
            this.rotateRight(n.sibling());
        } else if (n == n.parent.right && TupleRBTree.nodeColor(n.sibling()) == Color.BLACK && TupleRBTree.nodeColor(n.sibling().right) == Color.RED && TupleRBTree.nodeColor(n.sibling().left) == Color.BLACK) {
            n.sibling().color = Color.RED;
            n.sibling().right.color = Color.BLACK;
            this.rotateLeft(n.sibling());
        }
        this.deleteCase6(n);
    }

    private void deleteCase6(Node<K> n) {
        n.sibling().color = TupleRBTree.nodeColor(n.parent);
        n.parent.color = Color.BLACK;
        if (n == n.parent.left) {
            n.sibling().right.color = Color.BLACK;
            this.rotateLeft(n.parent);
        } else {
            n.sibling().left.color = Color.BLACK;
            this.rotateRight(n.parent);
        }
    }

    public void print() {
        TupleRBTree.printHelper(this.root, 0);
    }

    private static void printHelper(Node<?> n, int indent) {
        if (n == null) {
            System.out.print("<empty tree>");
            return;
        }
        if (n.right != null) {
            TupleRBTree.printHelper(n.right, indent + 4);
        }
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
        if (n.color == Color.BLACK) {
            System.out.println(n.key);
        } else {
            System.out.println("<" + n.key + ">");
        }
        if (n.left != null) {
            TupleRBTree.printHelper(n.left, indent + 4);
        }
    }

    public static class Node<K extends Comparable<? super K>>
    extends TupleList
    implements Entry<TupleList>,
    Comparable<Node<K>> {
        public K key;
        private Node<K> left;
        private Node<K> right;
        private Node<K> parent;
        private Color color = Color.RED;

        public Node(K key) {
            this.key = key;
        }

        public Node<K> grandparent() {
            return this.parent.parent;
        }

        public Node<K> sibling() {
            return this == this.parent.left ? this.parent.right : this.parent.left;
        }

        public Node<K> uncle() {
            return this.parent.sibling();
        }

        @Override
        public String toString() {
            return "Node key=" + this.key;
        }

        @Override
        public void setNext(TupleList next) {
        }

        @Override
        public TupleList getNext() {
            return null;
        }

        @Override
        public int compareTo(Node<K> other) {
            return this.key.compareTo(other.key);
        }

        protected void copyStateInto(Node<K> other) {
            super.copyStateInto(other);
            other.key = this.key;
        }
    }

    public static enum Color {
        RED,
        BLACK;

    }

    public static class RangeFastIterator<K extends Comparable<? super K>>
    implements FastIterator {
        private Node<K> upperBound;
        private Node<K> next;

        public RangeFastIterator(Node<K> lowerNearest, Node<K> upperNearest) {
            this.next = lowerNearest;
            this.upperBound = upperNearest;
        }

        @Override
        public Entry next(Entry object) {
            Node<K> temp = this.next;
            this.next = this.checkUpperBound(this.recurse(this.next));
            return temp;
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }

        private Node<K> recurse(Node<K> current) {
            if (current == null) {
                return null;
            }
            if (current.right != null) {
                Node p = current.right;
                while (p.left != null) {
                    p = p.left;
                }
                return p;
            }
            Node p = current.parent;
            Node<K> ch = current;
            while (p != null && ch == p.right) {
                ch = p;
                p = p.parent;
            }
            return p;
        }

        public Node<K> checkUpperBound(Node<K> current) {
            if (this.upperBound == null) {
                return current;
            }
            return current == null || current.compareTo(this.upperBound) > 0 ? null : current;
        }
    }

    public static enum Boundary {
        LOWER,
        UPPER;

    }
}

