/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.RBTree;
import org.drools.core.util.index.IndexUtil;
import org.drools.core.util.index.TupleList;

public class RightTupleIndexRangeRBTree
implements TupleMemory,
Externalizable {
    private RBTree<Comparable<Comparable>, TupleList> tree;
    private AbstractHashTable.FieldIndex ascendingIndex;
    private IndexUtil.ConstraintType ascendingConstraintType;
    private AbstractHashTable.FieldIndex descendingIndex;
    private IndexUtil.ConstraintType descendingConstraintType;
    private RightTupleBoundedFastIterator rightTupleBoundedFastIterator;
    private int size;

    public RightTupleIndexRangeRBTree() {
    }

    public RightTupleIndexRangeRBTree(IndexUtil.ConstraintType ascendingConstraintType, AbstractHashTable.FieldIndex ascendingIndex, IndexUtil.ConstraintType descendingConstraintType, AbstractHashTable.FieldIndex descendingIndex) {
        this.ascendingIndex = ascendingIndex;
        this.ascendingConstraintType = ascendingConstraintType;
        this.descendingIndex = descendingIndex;
        this.descendingConstraintType = descendingConstraintType;
        this.tree = new RBTree();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tree);
        out.writeObject(this.ascendingIndex);
        out.writeObject((Object)this.ascendingConstraintType);
        out.writeObject(this.descendingIndex);
        out.writeObject((Object)this.descendingConstraintType);
        out.writeInt(this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tree = (RBTree)in.readObject();
        this.ascendingIndex = (AbstractHashTable.FieldIndex)in.readObject();
        this.ascendingConstraintType = (IndexUtil.ConstraintType)((Object)in.readObject());
        this.descendingIndex = (AbstractHashTable.FieldIndex)in.readObject();
        this.descendingConstraintType = (IndexUtil.ConstraintType)((Object)in.readObject());
        this.size = in.readInt();
    }

    @Override
    public void add(Tuple tuple) {
        Comparable key = this.getRightIndexedValue(tuple);
        TupleList list = this.tree.lookup(key);
        if (list == null) {
            list = new TupleList();
            this.tree.insert(key, list);
        }
        list.add(tuple);
        ++this.size;
    }

    @Override
    public void remove(Tuple tuple) {
        tuple.getMemory().remove(tuple);
        --this.size;
    }

    @Override
    public void removeAdd(Tuple tuple) {
        this.remove(tuple);
        this.add(tuple);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Entry[] toArray() {
        RBTree.Node node;
        FastIterator it = this.tree.fastIterator();
        if (it == null) {
            return new Entry[0];
        }
        ArrayList toBeRemoved = new ArrayList();
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        while ((node = (RBTree.Node)it.next(null)) != null) {
            TupleList bucket = (TupleList)node.value;
            if (bucket.size() == 0) {
                toBeRemoved.add(node.key);
                continue;
            }
            for (Tuple entry = bucket.getFirst(); entry != null; entry = (Tuple)entry.getNext()) {
                result.add(entry);
            }
        }
        for (Comparable key : toBeRemoved) {
            this.tree.delete(key);
        }
        return result.toArray(new Tuple[result.size()]);
    }

    @Override
    public Tuple getFirst(Tuple leftTuple) {
        Comparable lowerBound = this.getLeftAscendingIndexedValue(leftTuple);
        Tuple rightTuple = this.getNext(lowerBound, true);
        return rightTuple == null ? null : this.checkUpperBound(rightTuple, this.getLeftDescendingIndexedValue(leftTuple));
    }

    private Tuple checkUpperBound(Tuple rightTuple, Comparable upperBound) {
        int compResult = this.getRightIndexedValue(rightTuple).compareTo(upperBound);
        return compResult < 0 || compResult == 0 && this.descendingConstraintType == IndexUtil.ConstraintType.LESS_OR_EQUAL ? rightTuple : null;
    }

    @Override
    public Iterator iterator() {
        TupleList list = (TupleList)this.tree.first().value;
        Tuple firstTuple = list != null ? list.getFirst() : null;
        return new FastIterator.IteratorAdapter(this.fastIterator(), firstTuple);
    }

    @Override
    public boolean contains(Tuple tuple) {
        Comparable key = this.getRightIndexedValue(tuple);
        return this.tree.lookup(key) != null;
    }

    @Override
    public FastIterator fastIterator() {
        if (this.rightTupleBoundedFastIterator != null) {
            this.rightTupleBoundedFastIterator = new RightTupleBoundedFastIterator();
        }
        return this.rightTupleBoundedFastIterator;
    }

    @Override
    public FastIterator fullFastIterator() {
        if (this.rightTupleBoundedFastIterator != null) {
            this.rightTupleBoundedFastIterator = new RightTupleBoundedFastIterator();
        }
        return this.rightTupleBoundedFastIterator;
    }

    @Override
    public FastIterator fullFastIterator(Tuple tuple) {
        FastIterator fastIterator = this.fullFastIterator();
        Comparable key = this.getRightIndexedValue(tuple);
        fastIterator.next(this.getNext(key, true));
        return fastIterator;
    }

    @Override
    public TupleMemory.IndexType getIndexType() {
        return TupleMemory.IndexType.COMPARISON;
    }

    private Tuple getNext(Comparable lowerBound, boolean first) {
        RBTree.Node<Comparable<Comparable>, TupleList> firstNode;
        while (true) {
            switch (this.ascendingConstraintType) {
                case GREATER_THAN: {
                    firstNode = this.tree.findNearestNode(lowerBound, false, RBTree.Boundary.LOWER);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    firstNode = this.tree.findNearestNode(lowerBound, first, RBTree.Boundary.LOWER);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot call remove constraint of type: " + this.ascendingConstraintType);
                }
            }
            if (firstNode == null || ((TupleList)firstNode.value).size() != 0) break;
            this.tree.delete((Comparable<Comparable>)firstNode.key);
        }
        return firstNode == null ? null : ((TupleList)firstNode.value).getFirst();
    }

    private Comparable getLeftAscendingIndexedValue(Tuple leftTuple) {
        return (Comparable)this.ascendingIndex.getDeclaration().getExtractor().getValue(leftTuple.get(this.ascendingIndex.getDeclaration()).getObject());
    }

    private Comparable getLeftDescendingIndexedValue(Tuple leftTuple) {
        return (Comparable)this.descendingIndex.getDeclaration().getExtractor().getValue(leftTuple.get(this.descendingIndex.getDeclaration()).getObject());
    }

    private Comparable getRightIndexedValue(Tuple rightTuple) {
        return (Comparable)this.ascendingIndex.getExtractor().getValue(rightTuple.getFactHandle().getObject());
    }

    @Override
    public void clear() {
        this.tree = new RBTree();
    }

    public class RightTupleBoundedFastIterator
    implements FastIterator {
        private Comparable upperBound;

        public void setUpperBound(Tuple leftTuple) {
            this.upperBound = RightTupleIndexRangeRBTree.this.getLeftDescendingIndexedValue(leftTuple);
        }

        @Override
        public Entry next(Entry object) {
            if (object == null) {
                return null;
            }
            Tuple rightTuple = (Tuple)object;
            Tuple next = (Tuple)rightTuple.getNext();
            if (next != null) {
                return next;
            }
            Comparable key = RightTupleIndexRangeRBTree.this.getRightIndexedValue(rightTuple);
            next = RightTupleIndexRangeRBTree.this.getNext(key, false);
            return next == null ? null : RightTupleIndexRangeRBTree.this.checkUpperBound(next, this.upperBound);
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }
}

