/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.process.instance.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.KogitoWorkItemHandlerNotFoundException;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.process.instance.KogitoWorkItem;
import org.drools.core.process.instance.KogitoWorkItemManager;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.impl.KogitoWorkItemImpl;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.Closeable;
import org.kie.kogito.process.workitem.Policy;

public class KogitoDefaultWorkItemManager
implements KogitoWorkItemManager,
Externalizable {
    private Map<String, KogitoWorkItem> workItems = new ConcurrentHashMap<String, KogitoWorkItem>();
    private InternalKnowledgeRuntime kruntime;
    private Map<String, WorkItemHandler> workItemHandlers = new HashMap<String, WorkItemHandler>();

    public KogitoDefaultWorkItemManager(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
    }

    public KogitoDefaultWorkItemManager() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workItems = (Map)in.readObject();
        this.kruntime = (InternalKnowledgeRuntime)in.readObject();
        this.workItemHandlers = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workItems);
        out.writeObject(this.kruntime);
        out.writeObject(this.workItemHandlers);
    }

    @Override
    public void internalExecuteWorkItem(KogitoWorkItem workItem) {
        ((KogitoWorkItemImpl)workItem).setId(UUID.randomUUID().toString());
        this.internalAddWorkItem(workItem);
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
        }
        handler.executeWorkItem((org.kie.api.runtime.process.WorkItem)workItem, (WorkItemManager)this);
    }

    @Override
    public void internalAddWorkItem(KogitoWorkItem workItem) {
        this.workItems.put(workItem.getId(), workItem);
    }

    @Override
    public void internalAbortWorkItem(String id) {
        KogitoWorkItemImpl workItem = (KogitoWorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler == null) {
                this.workItems.remove(workItem.getId());
                throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
            }
            handler.abortWorkItem((org.kie.api.runtime.process.WorkItem)workItem, (WorkItemManager)this);
            this.workItems.remove(workItem.getId());
        }
    }

    public void retryWorkItem(String workItemId) {
        KogitoWorkItem workItem = this.workItems.get(workItemId);
        this.retryWorkItem(workItem);
    }

    public void retryWorkItemWithParams(String workItemId, Map<String, Object> map) {
        KogitoWorkItem workItem = this.workItems.get(workItemId);
        if (workItem != null) {
            workItem.setParameters(map);
            this.retryWorkItem(workItem);
        }
    }

    private void retryWorkItem(KogitoWorkItem workItem) {
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.executeWorkItem((org.kie.api.runtime.process.WorkItem)workItem, (WorkItemManager)this);
            } else {
                throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
            }
        }
    }

    @Override
    public KogitoWorkItem getWorkItem(String id) {
        return this.workItems.get(id);
    }

    public void completeWorkItem(String id, Map<String, Object> results, Policy<?> ... policies) {
        KogitoWorkItem workItem = this.workItems.get(id);
        if (workItem != null) {
            workItem.setResults(results);
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(2);
            if (processInstance != null) {
                processInstance.signalEvent("workItemCompleted", (Object)workItem);
            }
            this.workItems.remove(id);
        }
    }

    public void abortWorkItem(String id, Policy<?> ... policies) {
        KogitoWorkItemImpl workItem = (KogitoWorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(3);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", (Object)workItem);
            }
            this.workItems.remove(id);
        }
    }

    public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    public Set<WorkItem> getWorkItems() {
        return new HashSet<WorkItem>(this.workItems.values());
    }

    public WorkItem getWorkItem(long id) {
        throw new UnsupportedOperationException("org.drools.core.process.instance.impl.KogitoDefaultWorkItemManager.getWorkItem -> TODO");
    }

    public void clear() {
        this.workItems.clear();
    }

    public void signalEvent(String type, Object event) {
        this.kruntime.signalEvent(type, event);
    }

    @Override
    public void signalEvent(String type, Object event, String processInstanceId) {
        this.kruntime.signalEvent(type, event, processInstanceId);
    }

    public void dispose() {
        if (this.workItemHandlers != null) {
            for (Map.Entry<String, WorkItemHandler> handlerEntry : this.workItemHandlers.entrySet()) {
                if (!(handlerEntry.getValue() instanceof Closeable)) continue;
                ((Closeable)handlerEntry.getValue()).close();
            }
        }
    }

    public void retryWorkItem(Long workItemID, Map<String, Object> params) {
        throw new UnsupportedOperationException("org.drools.core.process.instance.impl.KogitoDefaultWorkItemManager.retryWorkItem -> TODO");
    }

    @Override
    public void retryWorkItem(String workItemID, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            this.retryWorkItem(workItemID);
        } else {
            this.retryWorkItemWithParams(workItemID, params);
        }
    }

    @Override
    public void internalCompleteWorkItem(KogitoWorkItem workItem) {
    }

    public void internalExecuteWorkItem(WorkItem workItem) {
        throw new UnsupportedOperationException();
    }

    public void internalAddWorkItem(WorkItem workItem) {
        throw new UnsupportedOperationException();
    }

    public void internalAbortWorkItem(long id) {
        throw new UnsupportedOperationException();
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        throw new UnsupportedOperationException();
    }
}

