/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.core.rules.incubation.quarkus.support;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.EmptyMetaDataContext;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.ExtendedReferenceContext;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.common.ReferenceContext;
import org.kie.kogito.incubation.rules.InstanceQueryId;
import org.kie.kogito.incubation.rules.RuleUnitId;
import org.kie.kogito.incubation.rules.RuleUnitInstanceId;
import org.kie.kogito.incubation.rules.services.StatefulRuleUnitService;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.RuleUnitInstance;
import org.kie.kogito.rules.RuleUnits;

class StatefulRuleUnitServiceImpl
implements StatefulRuleUnitService {
    private final RuleUnits ruleUnits;

    public StatefulRuleUnitServiceImpl(RuleUnits ruleUnits) {
        this.ruleUnits = ruleUnits;
    }

    public MetaDataContext create(LocalId localId, ExtendedReferenceContext extendedDataContext) {
        if (!(localId instanceof RuleUnitId)) {
            throw new IllegalArgumentException("cannot parse rule unit id");
        }
        RuleUnitId ruleUnitId = (RuleUnitId)localId;
        ReferenceContext refCtx = extendedDataContext.data();
        if (!(refCtx instanceof RuleUnitData)) {
            throw new IllegalArgumentException("ExtendedReferenceContext#data must be a RuleUnitData");
        }
        RuleUnitData ruleUnitData = (RuleUnitData)refCtx;
        Class<RuleUnitData> aClass = this.toClass(ruleUnitId);
        RuleUnit ruleUnit = this.ruleUnits.create(aClass);
        RuleUnitInstance instance = ruleUnit.createInstance((org.drools.ruleunits.api.RuleUnitData)ruleUnitData);
        String instanceId = UUID.randomUUID().toString();
        this.ruleUnits.register(instanceId, instance);
        RuleUnitInstanceId ruleUnitInstanceId = ruleUnitId.instances().get(instanceId);
        return MapDataContext.of(Map.of("id", ruleUnitInstanceId.asLocalUri().path()));
    }

    private Class<RuleUnitData> toClass(RuleUnitId ruleUnitId) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(ruleUnitId.ruleUnitId());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public MetaDataContext dispose(LocalId localId) {
        if (!(localId instanceof RuleUnitInstanceId)) {
            throw new IllegalArgumentException("cannot parse rule unit id");
        }
        RuleUnitInstanceId ruleUnitInstanceId = (RuleUnitInstanceId)localId;
        RuleUnitInstance instance = this.ruleUnits.getRegisteredInstance(ruleUnitInstanceId.ruleUnitInstanceId());
        if (instance == null) {
            throw new IllegalArgumentException("Unknown instance " + localId);
        }
        instance.dispose();
        return EmptyMetaDataContext.Instance;
    }

    public MetaDataContext fire(LocalId localId) {
        if (!(localId instanceof RuleUnitInstanceId)) {
            throw new IllegalArgumentException("cannot parse rule unit id");
        }
        RuleUnitInstanceId ruleUnitInstanceId = (RuleUnitInstanceId)localId;
        RuleUnitInstance instance = this.ruleUnits.getRegisteredInstance(ruleUnitInstanceId.ruleUnitInstanceId());
        instance.fire();
        return EmptyMetaDataContext.Instance;
    }

    public Stream<ExtendedDataContext> query(LocalId localId, ExtendedReferenceContext params) {
        if (!(localId instanceof InstanceQueryId)) {
            throw new IllegalArgumentException("Not a valid instance query id " + localId);
        }
        InstanceQueryId queryId = (InstanceQueryId)localId;
        RuleUnitInstanceId ruleUnitInstanceId = queryId.ruleUnitInstanceId();
        RuleUnitInstance instance = this.ruleUnits.getRegisteredInstance(ruleUnitInstanceId.ruleUnitInstanceId());
        if (instance == null) {
            throw new IllegalArgumentException("Unknown instance " + localId);
        }
        List results = instance.executeQuery(queryId.queryId(), new Object[0]);
        return results.stream().map(r -> ExtendedDataContext.of((MetaDataContext)EmptyMetaDataContext.Instance, (DataContext)MapDataContext.of((Map)r)));
    }
}

