/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.workitems.impl;

import java.io.IOException;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.drools.core.process.instance.WorkItem;
import org.kie.internal.runtime.Closeable;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.internal.process.runtime.WorkItemNotFoundException;
import org.kie.kogito.process.workitem.NotAuthorizedException;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItemManager;
import org.kie.kogito.process.workitems.KogitoWorkItemHandlerNotFoundException;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;

public class KogitoDefaultWorkItemManager
implements InternalKogitoWorkItemManager {
    private Map<String, InternalKogitoWorkItem> workItems = new ConcurrentHashMap<String, InternalKogitoWorkItem>();
    private KogitoProcessRuntime kruntime;
    private Map<String, KogitoWorkItemHandler> workItemHandlers = new HashMap<String, KogitoWorkItemHandler>();

    public KogitoDefaultWorkItemManager(KogitoProcessRuntime kruntime) {
        this.kruntime = kruntime;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workItems);
        out.writeObject(this.kruntime);
        out.writeObject(this.workItemHandlers);
    }

    @Override
    public void internalExecuteWorkItem(InternalKogitoWorkItem workItem) {
        ((KogitoWorkItemImpl)workItem).setId(UUID.randomUUID().toString());
        this.internalAddWorkItem(workItem);
        KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
        }
        handler.executeWorkItem((KogitoWorkItem)workItem, (KogitoWorkItemManager)this);
    }

    @Override
    public void internalAddWorkItem(InternalKogitoWorkItem workItem) {
        this.workItems.put(workItem.getStringId(), workItem);
    }

    @Override
    public void internalRemoveWorkItem(String id) {
        this.workItems.remove(id);
    }

    @Override
    public void internalAbortWorkItem(String id) {
        KogitoWorkItemImpl workItem = (KogitoWorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler == null) {
                this.workItems.remove(workItem.getStringId());
                throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
            }
            handler.abortWorkItem((KogitoWorkItem)workItem, (KogitoWorkItemManager)this);
            this.workItems.remove(workItem.getStringId());
        }
    }

    public void retryWorkItem(String workItemId) {
        InternalKogitoWorkItem workItem = this.workItems.get(workItemId);
        this.retryWorkItem(workItem);
    }

    public void retryWorkItemWithParams(String workItemId, Map<String, Object> map) {
        InternalKogitoWorkItem workItem = this.workItems.get(workItemId);
        if (workItem != null) {
            workItem.setParameters(map);
            this.retryWorkItem(workItem);
        }
    }

    private void retryWorkItem(InternalKogitoWorkItem workItem) {
        if (workItem != null) {
            KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.executeWorkItem((KogitoWorkItem)workItem, (KogitoWorkItemManager)this);
            } else {
                throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
            }
        }
    }

    @Override
    public InternalKogitoWorkItem getWorkItem(String id) {
        return this.workItems.get(id);
    }

    public void completeWorkItem(String id, Map<String, Object> results, Policy<?> ... policies) {
        InternalKogitoWorkItem workItem = this.workItems.get(id);
        if (workItem != null) {
            workItem.setResults(results);
            KogitoProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceStringId());
            workItem.setState(2);
            if (processInstance != null) {
                processInstance.signalEvent("workItemCompleted", (Object)workItem);
            }
            this.workItems.remove(id);
        }
    }

    public void abortWorkItem(String id, Policy<?> ... policies) {
        KogitoWorkItemImpl workItem = (KogitoWorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            KogitoProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceStringId());
            workItem.setState(3);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", (Object)workItem);
            }
            this.workItems.remove(id);
        }
    }

    public void completeWorkItem(long l, Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }

    public void abortWorkItem(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<WorkItem> getWorkItems() {
        return new HashSet<WorkItem>(this.workItems.values());
    }

    public void registerWorkItemHandler(String workItemName, KogitoWorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    public void clear() {
        this.workItems.clear();
    }

    public void signalEvent(String type, Object event) {
        this.kruntime.signalEvent(type, event);
    }

    @Override
    public void signalEvent(String type, Object event, String processInstanceId) {
        this.kruntime.signalEvent(type, event, processInstanceId);
    }

    public void dispose() {
        if (this.workItemHandlers != null) {
            for (Map.Entry<String, KogitoWorkItemHandler> handlerEntry : this.workItemHandlers.entrySet()) {
                if (!(handlerEntry.getValue() instanceof Closeable)) continue;
                ((Closeable)handlerEntry.getValue()).close();
            }
        }
    }

    @Override
    public void retryWorkItem(String workItemID, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            this.retryWorkItem(workItemID);
        } else {
            this.retryWorkItemWithParams(workItemID, params);
        }
    }

    @Override
    public void internalCompleteWorkItem(InternalKogitoWorkItem workItem) {
    }

    public <T> T updateWorkItem(String id, Function<KogitoWorkItem, T> updater, Policy<?> ... policies) {
        KogitoWorkItem workItem = this.workItems.get(id);
        if (workItem != null) {
            if (!workItem.enforce(policies)) {
                throw new NotAuthorizedException("User is not authorized to access task instance with id " + id);
            }
            return updater.apply(workItem);
        }
        throw new WorkItemNotFoundException(id);
    }
}

