/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.api.model.runtime;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.Message;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="server-instance-details")
public class ServerInstance
extends ServerInstanceKey {
    @XmlElement(name="server-version")
    private String version;
    @XmlElement(name="server-messages")
    private Collection<Message> messages = new ArrayList<Message>();
    @XmlElement(name="containers")
    private Collection<Container> containers = new ArrayList<Container>();

    public ServerInstance() {
    }

    public ServerInstance(String serverTemplateId, String serverName, String serverInstanceId, String url, String version, Collection<Message> status, Collection<Container> containers) {
        super(serverTemplateId, serverName, serverInstanceId, url);
        this.version = version;
        this.messages.addAll(status);
        this.containers.addAll(containers);
    }

    public String getVersion() {
        return this.version;
    }

    public Collection<Message> getMessages() {
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        return this.messages;
    }

    public Collection<Container> getContainers() {
        if (this.containers == null) {
            this.containers = new ArrayList<Container>();
        }
        return this.containers;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMessages(Collection<Message> messages) {
        this.messages = messages;
    }

    public void addMessage(Message message) {
        this.messages.add(message);
    }

    public void setContainers(Collection<Container> containers) {
        this.containers = containers;
    }

    public void addContainer(Container container) {
        this.containers.add(container);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerInstance)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerInstance that = (ServerInstance)o;
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }
}

