/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.management;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.kie.server.controller.api.commands.KieServerControllerDescriptorCommand;
import org.kie.server.controller.api.model.KieServerControllerServiceResponse;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.websocket.common.decoder.KieServerControllerDescriptorCommandDecoder;
import org.kie.server.controller.websocket.common.encoder.KieServerControllerServiceResponseEncoder;
import org.kie.server.controller.websocket.management.KieServerMgmtCommandServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/websocket/controller/management", encoders={KieServerControllerServiceResponseEncoder.class}, decoders={KieServerControllerDescriptorCommandDecoder.class})
public class WebSocketKieServerMgmtControllerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketKieServerMgmtControllerImpl.class);
    private KieServerMgmtCommandServiceImpl commandService = KieServerMgmtCommandServiceImpl.getInstance();
    @Inject
    @Any
    private Instance<KieServerTemplateStorage> templateStorage;
    @Inject
    @Any
    private Instance<NotificationService> notificationService;

    @PostConstruct
    public void configure() {
        LOGGER.info("Kie Server Controller Management WebSocket service initialized");
        if (this.templateStorage == null || this.templateStorage.isUnsatisfied()) {
            LOGGER.warn("Unable to find template storage implementation, using in memory or loaded by ServiceLoader");
        } else {
            this.commandService.setTemplateStorage((KieServerTemplateStorage)this.templateStorage.get());
        }
        if (this.notificationService == null || this.notificationService.isUnsatisfied()) {
            LOGGER.warn("Unable to find notification service implementation, using logging only or loaded by ServiceLoader");
        } else {
            this.commandService.setNotificationService((NotificationService)this.notificationService.get());
        }
    }

    @OnOpen
    public void onManagementClientConnect(Session session, EndpointConfig config) {
        LOGGER.debug("New Web Socket Management Client session: {}", (Object)session.getId());
    }

    @OnMessage
    public void onMessage(KieServerControllerDescriptorCommand command, Session session) {
        LOGGER.debug("Message received on session: {}", (Object)session.getId());
        KieServerControllerServiceResponse response = this.commandService.executeCommand(command);
        try {
            session.getBasicRemote().sendObject((Object)response);
        }
        catch (IOException | EncodeException ex) {
            LOGGER.error("Error trying to send Web Socket response: {}", (Object)ex.getMessage(), (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    @OnClose
    public void onManagementClientDisconnect(Session session, CloseReason closeReason) {
        LOGGER.debug("Web Socket Management Client session: {}, disconnected, reason: {}", (Object)session.getId(), (Object)closeReason);
    }

    @OnError
    public void onManagementClientError(Session session, Throwable e) {
        LOGGER.error("Web Socket Management Client session: {}, unexpected error", (Object)session.getId(), (Object)e);
    }
}

