/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.scheduler;

import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class SchedulerTask
implements Runnable {
    protected ScheduledFuture future = null;
    protected boolean running = false;
    protected boolean fixedDelay = false;
    protected long fixedDelaySeconds = -1L;

    public abstract String getKey();

    public abstract String getDescription();

    public abstract void execute();

    public boolean isRunning() {
        return this.running;
    }

    public boolean isFixedDelay() {
        return this.fixedDelay;
    }

    public long getFixedDelaySeconds() {
        return this.fixedDelaySeconds;
    }

    public void setFixedDelaySeconds(long fixedDelaySeconds) {
        this.fixedDelaySeconds = fixedDelaySeconds;
    }

    public boolean isCancelled() {
        return this.future != null && this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future != null && this.future.isDone();
    }

    public boolean isMisfired() {
        return !this.running && this.future != null && this.future.getDelay(TimeUnit.MILLISECONDS) < 0L;
    }

    @Override
    public void run() {
        try {
            this.running = true;
            this.execute();
        }
        finally {
            this.running = false;
        }
    }

    public void cancel() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    public String printTimeToFire() {
        if (this.future != null) {
            long millis = this.future.getDelay(TimeUnit.MILLISECONDS);
            return SchedulerTask.formatTime(millis);
        }
        return null;
    }

    public long getMillisTimeToFire() {
        if (this.future != null) {
            return this.future.getDelay(TimeUnit.MILLISECONDS);
        }
        return 0L;
    }

    public Date getFireDate() {
        long delay = this.getMillisTimeToFire();
        if (delay < 0L) {
            return null;
        }
        return new Date(System.currentTimeMillis() + delay);
    }

    public static String formatTime(long millis) {
        long milliseconds = millis;
        long seconds = milliseconds / 1000L;
        milliseconds %= 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        long weeks = days / 7L;
        String pattern = "{2}h {1}m {0}s";
        if ((days %= 7L) > 0L) {
            pattern = "{3}d {2}h {1}m {0}s";
        }
        if (weeks > 0L) {
            pattern = "{4} sem. {3}d {2}h {1}m {0}s";
        }
        return MessageFormat.format(pattern, new Long(seconds), new Long(minutes), new Long(hours), new Long(days), new Long(weeks));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("key=").append(this.getKey()).append(", ");
        buf.append(this.getDescription());
        return buf.toString();
    }
}

