/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.projects;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kie.soup.project.datamodel.oracle.MethodInfo;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassToGenericClassConverter;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DenyLists;

public class ClassMethodInspector {
    private final Set<MethodInfo> methods = new HashSet<MethodInfo>();

    public ClassMethodInspector(Class<?> clazz, ClassToGenericClassConverter converter) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method aMethod = methods[i];
            String methodName = aMethod.getName();
            if (!this.isNotGetterOrSetter(aMethod) || DenyLists.isClassMethodInDenyList(clazz, methodName)) continue;
            Class<?>[] listParam = aMethod.getParameterTypes();
            MethodInfo info = new MethodInfo(methodName, this.convertParameterTypes(converter, listParam), aMethod.getReturnType(), this.obtainGenericType(aMethod.getGenericReturnType()), converter.translateClassToGenericType(aMethod.getReturnType()));
            this.methods.add(info);
        }
    }

    private List<String> convertParameterTypes(ClassToGenericClassConverter converter, Class<?>[] listParam) {
        ArrayList<String> params = new ArrayList<String>();
        if (listParam.length == 0) {
            return params;
        }
        for (int i = 0; i < listParam.length; ++i) {
            String type = converter.translateClassToGenericType(listParam[i]);
            params.add(type);
        }
        return params;
    }

    private boolean isNotGetterOrSetter(Method m) {
        return !this.isSetter(m) && !this.isGetter(m) && !this.isBooleanGetter(m);
    }

    private boolean isSetter(Method m) {
        String name = m.getName();
        int parameterCount = m.getParameterTypes().length;
        if (parameterCount != 1) {
            return false;
        }
        return name.length() > 3 && name.startsWith("set");
    }

    private boolean isGetter(Method m) {
        String name = m.getName();
        int parameterCount = m.getParameterTypes().length;
        if (parameterCount != 0) {
            return false;
        }
        return name.length() > 3 && name.startsWith("get");
    }

    private boolean isBooleanGetter(Method m) {
        String name = m.getName();
        int parameterCount = m.getParameterTypes().length;
        if (parameterCount != 0) {
            return false;
        }
        return name.length() > 2 && name.startsWith("is") && (Boolean.class.isAssignableFrom(m.getReturnType()) || Boolean.TYPE == m.getReturnType());
    }

    public List<String> getMethodNames() {
        ArrayList<String> methodList = new ArrayList<String>();
        for (MethodInfo info : this.methods) {
            methodList.add(info.getName());
        }
        return methodList;
    }

    public List<MethodInfo> getMethodInfos() {
        return new ArrayList<MethodInfo>(this.methods);
    }

    private String obtainGenericType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type goodType = null;
            Type[] typeArray = pt.getActualTypeArguments();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type t;
                goodType = t = typeArray[i];
            }
            if (goodType != null) {
                if (goodType instanceof Class) {
                    return ((Class)goodType).getName();
                }
                int index = goodType.toString().lastIndexOf(".");
                return goodType.toString().substring(index + 1);
            }
            return null;
        }
        return null;
    }
}

