/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graph_layouter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kohsuke.graph_layouter.impl.Cluster;
import org.kohsuke.graph_layouter.impl.Dfs;
import org.kohsuke.graph_layouter.impl.EdgeDirection;
import org.kohsuke.graph_layouter.impl.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyBuilder {
    public <T> void assignLevels(Collection<Vertex<T>> graph, EdgeDirection dir) {
        this.topologicalSort(graph, dir);
        this.fall(graph, dir);
    }

    public <T> List<Vertex<T>> topologicalSort(Collection<Vertex<T>> graph, EdgeDirection dir) {
        final ArrayList<Vertex<T>> topoOrder = new ArrayList<Vertex<T>>(graph.size());
        new Dfs<T>(dir){

            @Override
            protected void out(Vertex<T> v) {
                topoOrder.add(v);
            }
        }.run(graph);
        EdgeDirection rdir = dir.opposite();
        for (int i = graph.size() - 1; i >= 0; --i) {
            Vertex v = (Vertex)topoOrder.get(i);
            int level = 0;
            for (Vertex w : rdir.getEdges(v)) {
                switch (dir) {
                    case FORWARD: {
                        level = Math.max(level, w.level + 1);
                        break;
                    }
                    case BACKWARD: {
                        level = Math.min(level, w.level - 1);
                    }
                }
            }
            v.level = level;
        }
        return topoOrder;
    }

    public <T> void fall(Collection<Vertex<T>> graph, EdgeDirection dir) {
        boolean hasDrop;
        do {
            assert (this.nothingInCluster(graph));
            for (Vertex<T> v : graph) {
                if (v.cluster != null) continue;
                new Cluster().add(v);
            }
            assert (this.allBelongsToCluster(graph));
            for (Vertex<T> v : graph) {
                for (Vertex<T> w : dir.getEdges(v)) {
                    if (v.cluster == w.cluster) continue;
                    assert (Math.abs(w.level - v.level) > 1);
                    v.cluster.dropHeight = Math.min(v.cluster.dropHeight, Math.abs(w.level - v.level) - 1);
                }
            }
            hasDrop = false;
            for (Vertex<T> v : graph) {
                int h = v.cluster.dropHeight;
                if (h != Integer.MAX_VALUE) {
                    assert (h > 0);
                    hasDrop = true;
                    v.level += dir.sign() * h;
                }
                v.cluster = null;
            }
        } while (hasDrop);
    }

    private <T> boolean nothingInCluster(Collection<Vertex<T>> graph) {
        for (Vertex<T> v : graph) {
            assert (v.cluster == null);
        }
        return true;
    }

    private <T> boolean allBelongsToCluster(Collection<Vertex<T>> graph) {
        for (Vertex<T> v : graph) {
            assert (v.cluster != null);
        }
        return true;
    }
}

