/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graph_layouter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.kohsuke.graph_layouter.impl.Dfs;
import org.kohsuke.graph_layouter.impl.EdgeDirection;
import org.kohsuke.graph_layouter.impl.Level;
import org.kohsuke.graph_layouter.impl.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LevelMap<T> {
    private final SortedMap<Integer, Level<T>> core = new TreeMap<Integer, Level<T>>();

    public LevelMap() {
    }

    public LevelMap(Collection<Vertex<T>> graph) {
        new Dfs<T>(EdgeDirection.FORWARD){

            @Override
            protected void in(Vertex<T> v) {
                LevelMap.this.make((int)v.level).vertices.add(v);
            }
        }.run(graph);
        for (Level<T> l : this.levels()) {
            l.assignOrder();
        }
    }

    public Collection<Level<T>> levels() {
        return this.core.values();
    }

    public Level<T> get(int n) {
        return (Level)this.core.get(n);
    }

    public Level<T> make(int n) {
        Level l = (Level)this.core.get(n);
        if (l != null) {
            return l;
        }
        if (this.core.isEmpty()) {
            l = new Level(n);
            this.core.put(l.n, l);
            return l;
        }
        int k = this.core.firstKey();
        if (n < k) {
            l = (Level)this.core.get(k);
            while (l.n != n) {
                l = l.makePrev();
                this.core.put(l.n, l);
            }
            return l;
        }
        k = this.core.lastKey();
        l = (Level)this.core.get(k);
        assert (k < n);
        while (l.n != n) {
            l = l.makeNext();
            this.core.put(l.n, l);
        }
        return l;
    }

    public Level<T> first() {
        return (Level)this.core.get(this.core.firstKey());
    }

    public Level<T> last() {
        return (Level)this.core.get(this.core.lastKey());
    }

    public int countCrossing() {
        int crossing = 0;
        for (Level<T> lv : this.levels()) {
            crossing += lv.countCrossings();
        }
        return crossing;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Level<T> lv : this.levels()) {
            buf.append(lv.toString());
            buf.append('\n');
        }
        return buf.toString();
    }

    public final class Memento {
        private final List<Level.Memento> mementos = new ArrayList<Level.Memento>();

        public Memento() {
            for (Level lv : LevelMap.this.levels()) {
                this.mementos.add(lv.new Level.Memento());
            }
        }

        public void restore() {
            for (Level.Memento m : this.mementos) {
                m.restore();
            }
        }
    }
}

