/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.groovy.sandbox.impl;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;

public class RejectEverythingInterceptor
extends GroovyInterceptor {
    @Override
    public Object onMethodCall(GroovyInterceptor.Invoker invoker, Object receiver, String method, Object ... args) throws Throwable {
        throw new SecurityException("Rejecting unsandboxed method call: " + RejectEverythingInterceptor.getClassName(receiver) + "." + method + RejectEverythingInterceptor.getArgumentClassNames(args));
    }

    @Override
    public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
        throw new SecurityException("Rejecting unsandboxed static method call: " + RejectEverythingInterceptor.getClassName(receiver) + "." + method + RejectEverythingInterceptor.getArgumentClassNames(args));
    }

    @Override
    public Object onNewInstance(GroovyInterceptor.Invoker invoker, Class receiver, Object ... args) throws Throwable {
        throw new SecurityException("Rejecting unsandboxed constructor call: " + RejectEverythingInterceptor.getClassName(receiver) + RejectEverythingInterceptor.getArgumentClassNames(args));
    }

    @Override
    public Object onSuperCall(GroovyInterceptor.Invoker invoker, Class senderType, Object receiver, String method, Object ... args) throws Throwable {
        throw new SecurityException("Rejecting unsandboxed super method call: " + RejectEverythingInterceptor.getClassName(receiver) + "." + method + RejectEverythingInterceptor.getArgumentClassNames(args));
    }

    @Override
    public void onSuperConstructor(GroovyInterceptor.Invoker invoker, Class receiver, Object ... args) throws Throwable {
        throw new SecurityException("Rejecting unsandboxed super constructor call: " + RejectEverythingInterceptor.getClassName(receiver) + RejectEverythingInterceptor.getArgumentClassNames(args));
    }

    @Override
    public Object onGetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property) throws Throwable {
        throw new SecurityException("Rejecting unsandboxed property get: " + RejectEverythingInterceptor.getClassName(receiver) + "." + property);
    }

    @Override
    public Object onSetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property, Object value) throws Throwable {
        throw new SecurityException("Rejecting unsandboxed property set: " + RejectEverythingInterceptor.getClassName(receiver) + "." + property + " = " + RejectEverythingInterceptor.getClassName(value));
    }

    @Override
    public Object onGetAttribute(GroovyInterceptor.Invoker invoker, Object receiver, String attribute) throws Throwable {
        throw new SecurityException("Rejecting unsandboxed attribute get: " + RejectEverythingInterceptor.getClassName(receiver) + "." + attribute);
    }

    @Override
    public Object onSetAttribute(GroovyInterceptor.Invoker invoker, Object receiver, String attribute, Object value) throws Throwable {
        throw new SecurityException("Rejecting unsandboxed attribute set: " + RejectEverythingInterceptor.getClassName(receiver) + "." + attribute + " = " + RejectEverythingInterceptor.getClassName(value));
    }

    @Override
    public Object onGetArray(GroovyInterceptor.Invoker invoker, Object receiver, Object index) throws Throwable {
        throw new SecurityException("Rejecting unsandboxed array get: " + RejectEverythingInterceptor.getClassName(receiver) + "[" + RejectEverythingInterceptor.getArrayIndex(index) + "]");
    }

    @Override
    public Object onSetArray(GroovyInterceptor.Invoker invoker, Object receiver, Object index, Object value) throws Throwable {
        throw new SecurityException("Rejecting unsandboxed array set: " + RejectEverythingInterceptor.getClassName(receiver) + "[" + RejectEverythingInterceptor.getArrayIndex(index) + "] = " + RejectEverythingInterceptor.getClassName(value));
    }

    private static String getClassName(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        return value.getClass().getName();
    }

    private static String getArgumentClassNames(Object[] args) {
        return Stream.of(args).map(RejectEverythingInterceptor::getClassName).collect(Collectors.joining(", ", "(", ")"));
    }

    private static String getArrayIndex(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        return value.getClass().getName();
    }
}

