/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.kohsuke.stapler.export.Exported;

public class ExportedBeanAnnotationProcessor
implements AnnotationProcessor {
    private final AnnotationProcessorEnvironment env;

    public ExportedBeanAnnotationProcessor(AnnotationProcessorEnvironment env) {
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        try {
            File out = new File((String)this.env.getOptions().get("-d"));
            AnnotationTypeDeclaration $exposed = (AnnotationTypeDeclaration)this.env.getTypeDeclaration(Exported.class.getName());
            HashMap<TypeDeclaration, ArrayList<MemberDeclaration>> props = new HashMap<TypeDeclaration, ArrayList<MemberDeclaration>>();
            for (Declaration d : this.env.getDeclarationsAnnotatedWith($exposed)) {
                MemberDeclaration md = (MemberDeclaration)d;
                TypeDeclaration owner = md.getDeclaringType();
                ArrayList<MemberDeclaration> list = (ArrayList<MemberDeclaration>)props.get(owner);
                if (list == null) {
                    list = new ArrayList<MemberDeclaration>();
                    props.put(owner, list);
                }
                list.add(md);
            }
            File beans = new File(out, "META-INF/exposed.stapler-beans");
            TreeSet<String> exposedBeanNames = new TreeSet<String>();
            if (beans.exists()) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(beans)));
                while ((line = in.readLine()) != null) {
                    exposedBeanNames.add(line.trim());
                }
                in.close();
            }
            for (Map.Entry e : props.entrySet()) {
                exposedBeanNames.add(((TypeDeclaration)e.getKey()).getQualifiedName());
                final Properties javadocs = new Properties();
                for (MemberDeclaration md : (List)e.getValue()) {
                    md.accept((DeclarationVisitor)new SimpleDeclarationVisitor(){

                        public void visitFieldDeclaration(FieldDeclaration f) {
                            String javadoc = f.getDocComment();
                            if (javadoc != null) {
                                javadocs.put(f.getSimpleName(), javadoc);
                            }
                        }

                        public void visitMethodDeclaration(MethodDeclaration m) {
                            String javadoc = m.getDocComment();
                            if (javadoc != null) {
                                javadocs.put(m.getSimpleName() + "()", javadoc);
                            }
                        }
                    });
                }
                File javadocFile = new File(((TypeDeclaration)e.getKey()).getQualifiedName().replace('.', '/') + ".javadoc");
                this.env.getMessager().printNotice("Generating " + javadocFile);
                OutputStream os = this.env.getFiler().createBinaryFile(Filer.Location.CLASS_TREE, "", javadocFile);
                try {
                    javadocs.store(os, null);
                }
                finally {
                    os.close();
                }
            }
            beans.getParentFile().mkdirs();
            PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(beans), "UTF-8"));
            for (String beanName : exposedBeanNames) {
                w.println(beanName);
            }
            w.close();
        }
        catch (IOException x) {
            this.env.getMessager().printError(x.toString());
        }
    }
}

