/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.lang.Klass;

public final class JellyViewScript
implements Script {
    private static final Logger LOGGER = Logger.getLogger(JellyViewScript.class.getName());
    public final Class from;
    public final Klass<?> fromKlass;
    public final URL source;
    private Script base;

    public JellyViewScript(Class from, URL source, Script base) {
        this.from = from;
        this.fromKlass = Klass.java((Class)from);
        this.source = source;
        this.base = base;
    }

    public JellyViewScript(Klass from, URL source, Script base) {
        this.from = from.toJavaClass();
        this.fromKlass = from;
        this.source = source;
        this.base = base;
    }

    public Script compile() throws JellyException {
        this.base = this.base.compile();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(JellyContext context, XMLOutput output) throws JellyTagException {
        Thread t = Thread.currentThread();
        String n = t.getName();
        String url = this.source.toExternalForm();
        String c = this.from.getName();
        c = c.substring(c.lastIndexOf(46) + 1);
        String n2 = n + " " + c.replace('$', '/') + "/" + url.substring(url.lastIndexOf(47) + 1);
        t.setName(n2);
        LOGGER.fine(n2);
        try {
            this.base.run(context, output);
        }
        finally {
            t.setName(n);
        }
    }

    public String getName() {
        String url = this.source.toExternalForm();
        url = url.substring(url.lastIndexOf(47) + 1);
        url = url.substring(url.lastIndexOf(92) + 1);
        return this.from.getName().replace('.', '/').replace('$', '/') + '/' + url;
    }
}

