/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.kohsuke.stapler.jelly.RequiresView;

public class AnnotationProcessorImpl
extends AbstractProcessor {
    private final Map<TypeElement, MissingViews> missingViews = new HashMap<TypeElement, MissingViews>();
    private static final MissingViews EMPTY = new MissingViews();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of("*");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        this.missingViews.clear();
        for (TypeElement t : ElementFilter.typesIn(roundEnv.getRootElements())) {
            this.check(t);
        }
        this.missingViews.clear();
        return false;
    }

    private MissingViews check(TypeElement t) {
        MissingViews r = this.missingViews.get(t);
        if (r == null) {
            r = new MissingViews();
            this.missingViews.put(t, r);
            r.addAll(this.check(t.getSuperclass()));
            for (TypeMirror typeMirror : t.getInterfaces()) {
                r.addAll(this.check(typeMirror));
            }
            RequiresView a = t.getAnnotation(RequiresView.class);
            if (a != null) {
                r.addAll(Arrays.asList(a.value()));
            }
            if (!r.isEmpty() && !t.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, t.getQualifiedName() + " is missing views: " + r, t);
            }
        }
        return r;
    }

    private MissingViews check(TypeMirror t) {
        if (t.getKind() == TypeKind.DECLARED) {
            return this.check((TypeElement)((DeclaredType)t).asElement());
        }
        return EMPTY;
    }

    private static class MissingViews
    extends HashSet<String> {
        private MissingViews() {
        }
    }
}

