/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.config.PsqlConfiguration;
import com.datical.liquibase.ext.config.PsqlConfiguration$ConfigurationKeys;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import com.datical.liquibase.ext.tools.NativeExecutorRunner;
import com.datical.liquibase.ext.tools.NativeExecutorRunner$ConfigFile;
import com.datical.liquibase.ext.tools.NativeToolFileCreator;
import com.datical.liquibase.ext.tools.NativeToolFileCreator$FileTypeEnum;
import com.datical.liquibase.ext.util.NativeRunnerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class PsqlRunner
extends NativeExecutorRunner {
    private ChangeSet changeSet;
    private Sql[] sqlStrings;
    private File outFile = null;
    private Boolean keepTempFile = Boolean.FALSE;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private String logFile;
    private Integer timeout;
    private File psqlExec;
    private static final String EXECUTABLE_NAME = "psql";

    public PsqlRunner() {
    }

    public PsqlRunner(ChangeSet changeSet, Sql[] sqlArray) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlArray;
        this.setTimeout("1800");
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    protected List<String> createFinalCommandArray(Database object) {
        this.loadPsqlProperties();
        List list = super.createFinalCommandArray(object);
        try {
            this.writeSqlStrings();
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException((Throwable)exception);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = (Boolean)PsqlConfiguration.TEMP_KEEP.getCurrentValue();
        }
        if (!this.args.isEmpty()) {
            list.addAll(Collections.unmodifiableList(this.args));
        }
        String string = this.buildConnectionString((Database)object);
        list.add("--dbname");
        list.add(string);
        list.add("-v");
        list.add("ON_ERROR_STOP=1");
        if (this.outFile != null) {
            list.add("--file");
            list.add(this.outFile.getAbsolutePath());
        } else {
            list.add("--version");
        }
        string = StringUtil.join((Collection)list, (String)" ");
        object = String.format("%s:%s", this.getUserName(object.getConnection()), this.getPassword(object.getConnection()));
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("psql command:\n" + string.replaceAll((String)object, "*****:*****"));
        return list;
    }

    protected void processResult(int n2, String string, String string2, Database database) {
        if (this.logFile != null && this.outFile != null) {
            try {
                if (!string2.isEmpty()) {
                    Files.write(Paths.get(this.logFile, new String[0]), string2.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
                if (!string.isEmpty()) {
                    Files.write(Paths.get(this.logFile, new String[0]), string.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException((Throwable)iOException);
            }
        }
        if (n2 != 0 && !StringUtil.isEmpty((String)string2)) {
            String string3 = this.getCommandString() + " returned a code of " + n2 + "\n" + string2;
            throw new UnexpectedLiquibaseException(string3);
        }
        super.processResult(n2, string, string2, database);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCommand(Database object) {
        block8: {
            try {
                this.finalCommandArray = this.createFinalCommandArray((Database)object);
                super.executeCommand(object);
                if (this.outFile == null || !this.outFile.exists() || this.keepTempFile == null || !this.keepTempFile.booleanValue()) break block8;
            }
            catch (TimeoutException timeoutException) {
                try {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.processResult(0, null, null, (Database)object);
                    object = timeoutException.getMessage() + System.lineSeparator() + "Error: The psql executable failed to return a response with the configured timeout. Please check liquibase.psql.timeout specified in liquibase.psql.conf file, the LIQUIBASE_PSQL_TIMEOUT environment variable, or other config locations. Learn more at https://docs.liquibase.com/concepts/advanced/runwith.html" + System.lineSeparator();
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object)));
                    Scope.getCurrentScope().getLog(PsqlRunner.class).warning((String)object);
                    throw new LiquibaseException((Throwable)timeoutException);
                    catch (Exception exception) {
                        throw new LiquibaseException((Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Psql run script can be located at: " + this.outFile.getAbsolutePath());
                    }
                    throw throwable;
                }
            }
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Psql run script can be located at: " + this.outFile.getAbsolutePath());
            return;
        }
    }

    private void loadPsqlProperties() {
        this.setExecutable(NativeRunnerUtil.getExecutable(EXECUTABLE_NAME));
        Properties properties = this.getPropertiesFromConf(NativeExecutorRunner$ConfigFile.PSQL);
        this.setupConfProperties(properties);
        this.assignPropertiesFromConfiguration();
        PsqlRunner psqlRunner = this;
        psqlRunner.handlePsqlExecutable(psqlRunner.psqlExec);
        PsqlRunner psqlRunner2 = this;
        psqlRunner2.handleTimeout(psqlRunner2.timeout);
        this.logProperties();
    }

    private int determineTimeout(Properties object) {
        if ((object = ((Properties)object).getProperty("liquibase.psql.timeout")) == null) {
            return -1;
        }
        try {
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for property 'liquibase.psql.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com");
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a keep temp file name value of '" + this.tempName + "'");
        }
        if (this.logFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a log file value of '" + this.logFile + "'");
        }
    }

    private void handleArgs(String string) {
        if (string != null) {
            string = string.trim();
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a extra arguments of '" + string + "'");
            this.args = StringUtil.splitAndTrim((String)string, (String)" ");
        }
    }

    private void handleTimeout(Integer n2) {
        if (n2 != null) {
            NativeRunnerUtil.validateTimeout(n2);
            this.setTimeout(String.valueOf(n2));
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a timeout of '" + n2 + "'");
        }
    }

    private void handlePsqlExecutable(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            throw new UnexpectedLiquibaseException("The executable for the native executor 'psql' cannot be found at path '" + file.getAbsolutePath() + "' as specified in the liquibase.psql.conf file, the LIQUIBASE_PSQL_* environment variables, or other config locations. Learn more at https://docs.liquibase.com/concepts/advanced/runwith.html.");
        }
        if (!file.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'psql' executable in the liquibase.psql.conf file at " + file.getAbsolutePath() + " cannot be executed");
        }
        try {
            this.setExecutable(file.getCanonicalPath());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Using the 'psql' executable located at:  '" + file.getCanonicalPath() + "'");
            this.psqlExec = file;
            return;
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException((Throwable)iOException);
        }
    }

    private void setupConfProperties(Properties properties) {
        if (properties.containsKey(PsqlConfiguration$ConfigurationKeys.getFullKey("keep.temp"))) {
            this.keepTempFile = NativeRunnerUtil.getBooleanFromProperties(properties, PsqlConfiguration$ConfigurationKeys.getFullKey("keep.temp"));
        }
        if (properties.containsKey(PsqlConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = properties.getProperty(PsqlConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (properties.containsKey(PsqlConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = properties.getProperty(PsqlConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"));
        }
        if (properties.containsKey(PsqlConfiguration$ConfigurationKeys.getFullKey("logFile"))) {
            this.logFile = properties.getProperty(PsqlConfiguration$ConfigurationKeys.getFullKey("logFile"));
        }
        if (properties.containsKey("liquibase.psql.path")) {
            this.handlePsqlExecutable(new File(properties.getProperty("liquibase.psql.path")));
        }
        if (properties.containsKey("liquibase.psql.timeout")) {
            this.timeout = this.determineTimeout(properties);
        }
        if (properties.containsKey("liquibase.psql.args")) {
            this.handleArgs(properties.getProperty("liquibase.psql.args"));
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.tempName = PsqlConfiguration.TEMP_NAME.getCurrentValue() != null ? (String)PsqlConfiguration.TEMP_NAME.getCurrentValue() : this.tempName;
        this.tempPath = PsqlConfiguration.TEMP_PATH.getCurrentValue() != null ? (String)PsqlConfiguration.TEMP_PATH.getCurrentValue() : this.tempPath;
        this.logFile = PsqlConfiguration.LOG_FILE.getCurrentValue() != null ? (String)PsqlConfiguration.LOG_FILE.getCurrentValue() : this.logFile;
        this.keepTempFile = PsqlConfiguration.TEMP_KEEP.getCurrentValue() != null ? (Boolean)PsqlConfiguration.TEMP_KEEP.getCurrentValue() : this.keepTempFile;
        Integer n2 = this.timeout = PsqlConfiguration.TIMEOUT.getCurrentValue() != null ? (Integer)PsqlConfiguration.TIMEOUT.getCurrentValue() : this.timeout;
        if (PsqlConfiguration.PATH.getCurrentValue() != null) {
            this.handlePsqlExecutable(new File((String)PsqlConfiguration.PATH.getCurrentValue()));
        }
        if (PsqlConfiguration.ARGS.getCurrentValue() != null) {
            this.handleArgs((String)PsqlConfiguration.ARGS.getCurrentValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSqlStrings() {
        Object object;
        block13: {
            if (this.sqlStrings == null) return;
            if (this.sqlStrings.length == 0) {
                return;
            }
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Creating the SQL run script");
            object = new NativeToolFileCreator(this.changeSet, this.tempName, this.tempPath, true, this.keepTempFile == null ? ((Boolean)PsqlConfiguration.TEMP_KEEP.getDefaultValue()).booleanValue() : this.keepTempFile.booleanValue());
            try {
                this.outFile = ((NativeToolFileCreator)object).generateTemporaryFile(NativeToolFileCreator$FileTypeEnum.sql);
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException((Throwable)iOException);
            }
            object = Files.newBufferedWriter(Paths.get(this.outFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
            Throwable throwable = null;
            try {
                Sql[] sqlArray = this.sqlStrings;
                int n2 = this.sqlStrings.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = sqlArray[i2].toSql().replace("\r", "");
                    ((Writer)object).write(string);
                }
                ((Writer)object).write(";\n");
                if (object == null) return;
                if (throwable == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable4 = throwable2;
                    throwable = throwable2;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (object == null) throw throwable5;
                    if (throwable == null) {
                        ((BufferedWriter)object).close();
                        throw throwable5;
                    }
                    try {
                        ((BufferedWriter)object).close();
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                        throw throwable5;
                    }
                }
            }
            try {
                ((BufferedWriter)object).close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        ((BufferedWriter)object).close();
    }

    protected String buildConnectionString(Database object) {
        if (object == null) {
            return null;
        }
        object = object.getConnection();
        String string = this.getUserName((DatabaseConnection)object);
        String string2 = this.getPassword((DatabaseConnection)object);
        object = Pattern.compile(".*postgresql://(.*?):(\\d+)/([^?]+).*").matcher(object.getURL());
        if (!((Matcher)object).matches()) {
            throw new UnexpectedLiquibaseException("Could not determine proper postgres connection url.");
        }
        String string3 = ((Matcher)object).group(1);
        String string4 = ((Matcher)object).group(2);
        object = ((Matcher)object).group(3);
        return String.format("postgresql://%s:%s@%s:%s/%s", string, string2, string3, string4, object);
    }

    private String getUserName(DatabaseConnection databaseConnection) {
        String string = null;
        if (databaseConnection instanceof ProJdbcConnection) {
            string = ((ProJdbcConnection)databaseConnection).getUsername();
        }
        if (string == null) {
            string = databaseConnection.getConnectionUserName();
        }
        return StringUtil.trimToEmpty((String)string);
    }

    private String getPassword(DatabaseConnection databaseConnection) {
        String string = null;
        if (databaseConnection instanceof ProJdbcConnection) {
            string = ((ProJdbcConnection)databaseConnection).getPassword();
        }
        return StringUtil.trimToEmpty(string);
    }
}

