/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.AbstractChangelogRewriter;
import com.datical.liquibase.ext.changelog.ChangelogRewriter$MOD_TYPE;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.exception.LiquibaseException;
import liquibase.util.StringUtil;

public abstract class AbstractFormattedChangelogRewriter
extends AbstractChangelogRewriter {
    public static final String LABELS = " labels:";
    public static final String CONTEXT = " context:";
    public static final String CONTEXT_FILTER = " contextFilter:";
    protected static final String FORMATTED_LABELS_REGEX = ".*labels:(\\S*).*";
    protected static final Pattern FORMATTED_LABELS_PATTERN = Pattern.compile(".*labels:(\\S*).*", 2);
    protected static final String FORMATTED_CONTEXT_REGEX = ".*context:(\".*\"|\\S*).*";
    protected static final Pattern FORMATTED_CONTEXT_PATTERN = Pattern.compile(".*context:(\".*\"|\\S*).*", 2);
    protected static final String FORMATTED_CONTEXT_FILTER_REGEX = ".*contextFilter:(\".*\"|\\S*).*";
    protected static final Pattern FORMATTED_CONTEXT_FILTER_PATTERN = Pattern.compile(".*contextFilter:(\".*\"|\\S*).*", 2);
    protected final String FORMATTED_CHANGE_SET_REGEX = String.format("\\s*%s[\\s]*changeset\\s+(\"[^\"]+\"|[^:]+):\\s*(\"[^\"]+\"|\\S+).*", this.getSingleLineCommentSequence());
    protected final Pattern FORMATTED_CHANGE_SET_PATTERN = Pattern.compile(this.FORMATTED_CHANGE_SET_REGEX, 2);
    protected final String FORMATTED_ALT_CHANGE_SET_ONE_DASH_REGEX = String.format("%s[\\s]*changeset\\s.*", this.getSingleLineCommentOneCharacter());
    protected final Pattern FORMATTED_ALT_CHANGE_SET_ONE_DASH_PATTERN = Pattern.compile(this.FORMATTED_ALT_CHANGE_SET_ONE_DASH_REGEX, 2);
    protected final String FORMATTED_ALT_CHANGE_SET_NO_OTHER_INFO_REGEX = String.format("\\s*%s[\\s]*changeset[\\s]*.*$", this.getSingleLineCommentSequence());
    protected final Pattern FORMATTED_ALT_CHANGE_SET_NO_OTHER_INFO_PATTERN = Pattern.compile(this.FORMATTED_ALT_CHANGE_SET_NO_OTHER_INFO_REGEX, 2);
    private static final String FORMATTED_DBMS_REGEX = ".*dbms:([^,][\\w!,]+).*";
    private static final Pattern FORMATTED_DBMS_PATTERN = Pattern.compile(".*dbms:([^,][\\w!,]+).*", 2);
    protected static final String FORMATTED_IGNORE_REGEX = ".*ignore:(\\w*).*";
    protected static final Pattern FORMATTED_IGNORE_PATTERN = Pattern.compile(".*ignore:(\\w*).*", 2);
    protected final String FORMATTED_ALT_IGNORE_REGEX = String.format("%s[\\s]*ignore:(\\w+)", this.getSingleLineCommentSequence());
    protected final Pattern FORMATTED_ALT_IGNORE_PATTERN = Pattern.compile(this.FORMATTED_ALT_IGNORE_REGEX, 2);

    protected abstract String getSingleLineCommentOneCharacter();

    protected abstract String getSingleLineCommentSequence();

    protected abstract String getFirstLine();

    protected abstract String getSequenceName();

    @Override
    public String handle(String string2) {
        if (!string2.toLowerCase().contains(this.getFirstLine())) {
            throw new LiquibaseException(String.format("Changelog file '%s' is not in the formatted %s format", this.changelogFile, this.getSequenceName()));
        }
        AtomicReference<String> atomicReference = new AtomicReference<String>(string2);
        Arrays.stream(string2.replace("\r\n", "\n").split("\n")).forEach(string -> {
            if (this.matchForChangeset((String)string) && !this.isIgnored((String)string) && this.isDbmsMatch((String)string)) {
                this.modifyFormattedSequence(atomicReference, (String)string);
            }
        });
        return atomicReference.get();
    }

    private boolean isIgnored(String string) {
        Matcher matcher = FORMATTED_IGNORE_PATTERN.matcher(string);
        boolean bl2 = false;
        if (matcher.find()) {
            bl2 = matcher.group(1).equalsIgnoreCase("true");
        } else {
            matcher = this.FORMATTED_ALT_IGNORE_PATTERN.matcher(string);
            if (matcher.find()) {
                bl2 = matcher.group(1).equalsIgnoreCase("true");
            }
        }
        if (bl2) {
            string = "Ignoring changeset '" + this.createChangeSetDisplayString(string) + "'";
            Scope.getCurrentScope().getUI().sendMessage(string);
        }
        return bl2;
    }

    private String createChangeSetDisplayString(String string) {
        Object object = this.FORMATTED_CHANGE_SET_PATTERN.matcher(string);
        if (!((Matcher)object).find()) {
            return string;
        }
        string = ((Matcher)object).group(2);
        if (string != null) {
            string = string.replace("\"", "");
        }
        if ((object = ((Matcher)object).group(1)) != null) {
            object = ((String)object).replace("\"", "");
        }
        String string2 = this.determinePath(null);
        return String.format("%s::%s::%s", string, object, string2);
    }

    private boolean isDbmsMatch(String string) {
        Object object = FORMATTED_DBMS_PATTERN.matcher(string);
        boolean bl2 = true;
        if (((Matcher)object).find()) {
            object = ((Matcher)object).group(1);
            bl2 = this.databaseChangelog.isDbmsMatch((String)object);
        }
        if (!bl2) {
            object = "Mismatched DBMS value for changeset '" + this.createChangeSetDisplayString(string) + "'";
            Scope.getCurrentScope().getUI().sendMessage((String)object);
        }
        return bl2;
    }

    private String addNewLabelsOrContexts(String string, String string2) {
        string = this.modType == ChangelogRewriter$MOD_TYPE.LABELS ? String.format("%s%s%s ", string, LABELS, string2) : String.format("%s%s\"%s\" ", string, CONTEXT, string2);
        return string;
    }

    private boolean matchForChangeset(String string) {
        if (this.FORMATTED_CHANGE_SET_PATTERN.matcher(string).find()) {
            return true;
        }
        if (this.FORMATTED_ALT_CHANGE_SET_ONE_DASH_PATTERN.matcher(string).find()) {
            return true;
        }
        return this.FORMATTED_ALT_CHANGE_SET_NO_OTHER_INFO_PATTERN.matcher(string).find();
    }

    private void modifyFormattedSequence(AtomicReference<String> atomicReference, String string) {
        Matcher matcher = this.modType == ChangelogRewriter$MOD_TYPE.LABELS ? FORMATTED_LABELS_PATTERN.matcher(string) : this.getContextsMatcher(string);
        String string2 = null;
        if (matcher.find()) {
            string2 = matcher.groupCount() > 0 ? matcher.group(1) : null;
        }
        atomicReference.set(this.modifyValueInFormattedSequence(atomicReference.get(), string, string2));
    }

    private Matcher getContextsMatcher(String string) {
        Matcher matcher = FORMATTED_CONTEXT_PATTERN.matcher(string);
        if (matcher.find()) {
            matcher.reset();
            return matcher;
        }
        return FORMATTED_CONTEXT_FILTER_PATTERN.matcher(string);
    }

    private String modifyValueInFormattedSequence(String string, String string2, String string3) {
        Object object = this.FORMATTED_CHANGE_SET_PATTERN.matcher(string2);
        if ((object = this.matchChangeSet((Matcher)object)) == null) {
            Scope.getCurrentScope().getLog(AbstractFormattedChangelogRewriter.class).info("Unable to match changeset '" + string2 + "'");
            return string;
        }
        object = this.modType == ChangelogRewriter$MOD_TYPE.LABELS ? object.getLabels().toString() : this.createContextStringForFile((ChangeSet)object);
        if (StringUtil.isEmpty((String)object)) {
            return string;
        }
        if (string3 == null) {
            string3 = this.addNewLabelsOrContexts(string2, (String)object);
        } else {
            if (string3.trim().equals(object)) {
                return string;
            }
            string3 = this.modType == ChangelogRewriter$MOD_TYPE.LABELS ? string2.replace(LABELS.concat(String.valueOf(string3)), LABELS.concat(String.valueOf(object))) : (string2.contains(CONTEXT_FILTER) ? string2.replace(CONTEXT_FILTER.concat(String.valueOf(string3)), " contextFilter:\"" + (String)object + "\"") : string2.replace(CONTEXT.concat(String.valueOf(string3)), " context:\"" + (String)object + "\""));
        }
        return string.replace(string2, string3);
    }

    private ChangeSet matchChangeSet(Matcher object) {
        if (!((Matcher)object).find()) {
            return null;
        }
        String string = ((Matcher)object).group(2);
        if (string != null) {
            string = string.replace("\"", "");
        }
        if ((object = ((Matcher)object).group(1)) != null) {
            object = ((String)object).replace("\"", "");
        }
        String string2 = this.determinePath(null);
        return this.databaseChangelog.getChangeSet(string2, (String)object, string);
    }
}

