/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringListGetter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule$SupportedChangesetFormats;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.change.ChangeFactory;
import liquibase.changelog.ChangeSet;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.structure.DatabaseObject;

public class WarnOnSpecificChangeTypes
extends AbstractLiquibaseDynamicForecastRule {
    public static final Set<String> REGISTERED_CHANGE_NAMES = ((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getDefinedChanges().stream().map(String::toUpperCase).collect(Collectors.toSet());

    public WarnOnSpecificChangeTypes() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public String getName() {
        return "Warn on Use of User Defined ChangeTypes";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        Object object = StringListGetter.split((String)dynamicRule.getParameter(DynamicRuleParameterEnum.CHANGE_TYPE_LIST).getValue());
        Set<String> set = this.getChangeSetChanges(changeSet);
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (!set.stream().anyMatch(string::equalsIgnoreCase)) continue;
            string = String.format("A ChangeSet includes a '%s' change. This ChangeType has been flagged for review in your checks configuration. Review this ChangeSet to confirm that use of this ChangeType is acceptable.", string);
            this.addFailureRuleIteration(changeSet, string, dynamicRule);
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule);
    }

    private Set<String> getChangeSetChanges(ChangeSet changeSet) {
        return changeSet.getChanges().stream().map(LiquibaseSerializable::getSerializedObjectName).collect(Collectors.toSet());
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Collections.singletonList(new RuleParameter(DynamicRuleParameterEnum.CHANGE_TYPE_LIST));
    }

    @Override
    public String getDescription() {
        return "This check warns a user when a ChangeSet includes a ChangeType listed by the user as forbidden";
    }

    @Override
    public String getShortName() {
        return "DetectChangeType";
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule$SupportedChangesetFormats.MODELED;
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }
}

