/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.ChangeSetAuthorFilter;
import com.datical.liquibase.ext.changelog.filter.ChangeSetIdFilter;
import com.datical.liquibase.ext.changelog.filter.ChangeSetPathFilter;
import com.datical.liquibase.ext.changelog.filter.ProDbmsChangeSetFilter;
import com.datical.liquibase.ext.command.SetContextsCommandStep;
import com.datical.liquibase.ext.command.SetLabelsCommandStep;
import java.util.ArrayList;
import java.util.List;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionCommandStep;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.ChangeLogParseException;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;

public abstract class AbstractSetCommandStep
extends AbstractCommandStep {
    public static final String DATABASE_TYPE_NAME = "database.typeName";
    private DbUrlConnectionCommandStep connectionCommandStep = null;

    public static void validateDbmsString(String string) {
        if (!new ArrayList(Scope.getCurrentScope().getServiceLocator().findInstances(Database.class)).stream().anyMatch(database -> database.getShortName().equalsIgnoreCase(string))) {
            throw new IllegalArgumentException("Database name '" + string + "' does not match any supported database.");
        }
    }

    protected ChangeLogIterator createCommandRunIterator(String string, String string2, String string3, DatabaseChangeLog databaseChangeLog, List<ChangeSetFilter> list) {
        list = new ArrayList<ChangeSetFilter>(list);
        if (string != null) {
            list.add(new ChangeSetIdFilter(string));
        }
        if (string2 != null) {
            list.add(new ChangeSetAuthorFilter(string2));
        }
        if (string3 != null) {
            list.add(new ChangeSetPathFilter(string3));
        }
        return new ChangeLogIterator(databaseChangeLog, list);
    }

    protected DatabaseChangeLog parseDatabaseChangelog(String string, String string2, Database database) {
        ChangeLogParser changeLogParser = null;
        if (string != null) {
            changeLogParser = ChangeLogParserFactory.getInstance().getParser(string, Scope.getCurrentScope().getResourceAccessor());
            string2 = this.createChangeLogParameters(string2, database);
            try {
                changeLogParser = changeLogParser.parse(string, (ChangeLogParameters)string2, Scope.getCurrentScope().getResourceAccessor());
            }
            catch (ChangeLogParseException changeLogParseException) {
                string = String.format("%nThe changelog file %s cannot be found or is not a valid changelog: %s%nCorrect this issue and try to run checks again.", string, changeLogParseException.getMessage());
                Scope.getCurrentScope().getLog(SetLabelsCommandStep.class).severe(string);
                Scope.getCurrentScope().getUI().sendMessage(string);
                return null;
            }
        }
        return changeLogParser;
    }

    protected ChangeLogIterator getStandardChangelogIterator(Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog) {
        return new ChangeLogIterator(databaseChangeLog, new ChangeSetFilter[]{new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter()});
    }

    protected ChangeLogIterator getStandardChangelogIterator(String string, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog) {
        return new ChangeLogIterator(databaseChangeLog, new ChangeSetFilter[]{new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new ProDbmsChangeSetFilter(string)});
    }

    protected String getChangelogFileArg(CommandScope commandScope) {
        return (String)commandScope.getArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG);
    }

    protected String getContextsArg(CommandScope commandScope) {
        return (String)commandScope.getArgumentValue(SetLabelsCommandStep.CONTEXTS_ARG);
    }

    protected String getLabelFilterArg(CommandScope commandScope) {
        return (String)commandScope.getArgumentValue(SetLabelsCommandStep.LABEL_FILTER_ARG);
    }

    protected ChangeLogIterator createRunChangeLogIterator(CommandScope commandScope, Contexts object, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog) {
        object = this.getStandardChangelogIterator((Contexts)object, labelExpression, databaseChangeLog).getChangeSetFilters();
        return this.createCommandRunIterator((String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_ID_ARG), (String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_AUTHOR_ARG), (String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_PATH_ARG), databaseChangeLog, (List<ChangeSetFilter>)object);
    }

    protected ChangeLogIterator createRunChangeLogIterator(CommandScope commandScope, String object, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog) {
        object = this.getStandardChangelogIterator((String)object, contexts, labelExpression, databaseChangeLog).getChangeSetFilters();
        return this.createCommandRunIterator((String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_ID_ARG), (String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_AUTHOR_ARG), (String)commandScope.getArgumentValue(SetContextsCommandStep.CHANGESET_PATH_ARG), databaseChangeLog, (List<ChangeSetFilter>)object);
    }

    private ChangeLogParameters createChangeLogParameters(String string, Database database) {
        ChangeLogParameters changeLogParameters = new ChangeLogParameters();
        if (string != null) {
            changeLogParameters.set(DATABASE_TYPE_NAME, (Object)string);
        } else if (database != null) {
            changeLogParameters.set(DATABASE_TYPE_NAME, (Object)database.getShortName());
        }
        return changeLogParameters;
    }

    protected Database obtainDatabase(String string, CommandScope commandScope) {
        if ((string = string != null ? DatabaseFactory.getInstance().getDatabase(string) : null) == null && commandScope.getArgumentValue(SetLabelsCommandStep.URL_ARG) != null) {
            this.connectionCommandStep = new DbUrlConnectionCommandStep();
            string = this.connectionCommandStep.obtainDatabase(commandScope);
        }
        return string;
    }

    protected void cleanUp(CommandResultsBuilder commandResultsBuilder) {
        if (this.connectionCommandStep != null) {
            this.connectionCommandStep.cleanUp(commandResultsBuilder);
        }
    }

    protected ChangeLogIterator determineChangeLogIterator(CommandScope commandScope, String string, Database database, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog) {
        commandScope = string != null ? this.createRunChangeLogIterator(commandScope, string, contexts, labelExpression, databaseChangeLog) : (database != null ? this.createRunChangeLogIterator(commandScope, database.getShortName(), contexts, labelExpression, databaseChangeLog) : this.createRunChangeLogIterator(commandScope, contexts, labelExpression, databaseChangeLog));
        return commandScope;
    }
}

