/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.SnowflakeDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;

public class StoredProcedureSnapshotGenerator
extends AbstractStoredDatabaseLogicSnapshotGenerator {
    public StoredProcedureSnapshotGenerator() {
        super(StoredProcedure.class, new Class[]{Schema.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof OracleDatabase || database instanceof MySQLDatabase || database instanceof MSSQLDatabase || database instanceof DB2Database || database instanceof SnowflakeDatabase) {
            return super.getPriority(clazz, database);
        }
        return -1;
    }

    @Override
    protected String getObjectType(Database database) {
        return "PROCEDURE";
    }

    protected StoredDatabaseLogic<StoredProcedure> createReturnObject() {
        return new StoredProcedure();
    }

    @Override
    protected String getAddToSql(Schema schema, Database database) {
        if (database instanceof DB2Database) {
            return "SELECT PROCNAME AS OBJECT_NAME FROM SYSCAT.PROCEDURES where PROCSCHEMA='" + schema.getCatalogName() + "' AND definer not in ('SYSIBM') AND text is not null";
        }
        if (database instanceof Db2zDatabase) {
            return "SELECT NAME AS OBJECT_NAME FROM SYSIBM.SYSROUTINES where SCHEMA='" + schema.getCatalogName() + "' AND ROUTINETYPE = 'P' ";
        }
        return super.getAddToSql(schema, database);
    }

    @Override
    protected String getSnapshotObjectSql(StoredDatabaseLogic<?> storedDatabaseLogic, Database database) {
        if (database instanceof DB2Database) {
            return "select PROCSCHEMA AS OBJECT_SCHEMA, PROCNAME AS OBJECT_NAME, TEXT AS OBJECT_BODY, CREATE_TIME as CREATED, 'VALID' as STATUS FROM syscat.PROCEDURES where PROCSCHEMA='" + storedDatabaseLogic.getSchema().getCatalogName() + "' AND PROCNAME='" + storedDatabaseLogic.getName() + "' ";
        }
        if (database instanceof Db2zDatabase) {
            return "SELECT SCHEMA AS OBJECT_SCHEMA, NAME AS OBJECT_NAME, TEXT AS OBJECT_BODY, CREATEDTS as CREATED, 'VALID' as STATUS FROM SYSIBM.SYSROUTINES where SCHEMA='" + storedDatabaseLogic.getSchema().getCatalogName() + "' AND ROUTINETYPE = 'P' AND NAME='" + storedDatabaseLogic.getName() + "' ";
        }
        if (database instanceof MySQLDatabase) {
            return "SHOW CREATE PROCEDURE " + storedDatabaseLogic.getSchema().getCatalogName() + "." + storedDatabaseLogic.getName();
        }
        return super.getSnapshotObjectSql(storedDatabaseLogic, database);
    }
}

