/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.parser;

import java.io.InputStream;
import java.io.Reader;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.repackaged.net.sf.jsqlparser.JSQLParserException;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.parser.AbstractJSqlParser;
import liquibase.repackaged.net.sf.jsqlparser.parser.CCJSqlParser;
import liquibase.repackaged.net.sf.jsqlparser.parser.CCJSqlParserUtil$1;
import liquibase.repackaged.net.sf.jsqlparser.parser.CCJSqlParserUtil$2;
import liquibase.repackaged.net.sf.jsqlparser.parser.Node;
import liquibase.repackaged.net.sf.jsqlparser.parser.ParseException;
import liquibase.repackaged.net.sf.jsqlparser.parser.StatementListener;
import liquibase.repackaged.net.sf.jsqlparser.parser.StreamProvider;
import liquibase.repackaged.net.sf.jsqlparser.parser.StringProvider;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;

public final class CCJSqlParserUtil {
    public static final Logger LOGGER = Logger.getLogger(CCJSqlParserUtil.class.getName());
    public static final int ALLOWED_NESTING_DEPTH = 10;

    private CCJSqlParserUtil() {
    }

    public static Statement parse(Reader object) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        object = new CCJSqlParser(new StreamProvider((Reader)object));
        try {
            object = CCJSqlParserUtil.parseStatement((CCJSqlParser)object, executorService);
        }
        finally {
            executorService.shutdown();
        }
        return object;
    }

    public static Statement parse(String string) {
        return CCJSqlParserUtil.parse(string, null);
    }

    public static Statement parse(String object, Consumer<CCJSqlParser> consumer) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            object = CCJSqlParserUtil.parse((String)object, executorService, consumer);
        }
        finally {
            executorService.shutdown();
        }
        return object;
    }

    public static Statement parse(String string, ExecutorService executorService, Consumer<CCJSqlParser> consumer) {
        Object object = CCJSqlParserUtil.newParser(string);
        if (consumer != null) {
            consumer.accept((CCJSqlParser)object);
        }
        boolean bl2 = ((CCJSqlParser)object).getConfiguration().getAsBoolean(Feature.allowComplexParsing);
        LOGGER.info("Allowed Complex Parsing: ".concat(String.valueOf(bl2)));
        try {
            LOGGER.info("Trying SIMPLE parsing " + (bl2 ? "first" : "only"));
            object = CCJSqlParserUtil.parseStatement((CCJSqlParser)((AbstractJSqlParser)object).withAllowComplexParsing(false), executorService);
        }
        catch (JSQLParserException jSQLParserException) {
            LOGGER.info("Nesting Depth" + CCJSqlParserUtil.getNestingDepth(string));
            if (bl2 && CCJSqlParserUtil.getNestingDepth(string) <= 10) {
                LOGGER.info("Trying COMPLEX parsing when SIMPLE parsing failed");
                object = CCJSqlParserUtil.newParser(string);
                if (consumer != null) {
                    consumer.accept((CCJSqlParser)object);
                }
                object = CCJSqlParserUtil.parseStatement((CCJSqlParser)((AbstractJSqlParser)object).withAllowComplexParsing(true), executorService);
            }
            throw jSQLParserException;
        }
        return object;
    }

    public static CCJSqlParser newParser(String string) {
        return new CCJSqlParser(new StringProvider(string));
    }

    public static CCJSqlParser newParser(InputStream inputStream) {
        return new CCJSqlParser(new StreamProvider(inputStream));
    }

    public static CCJSqlParser newParser(InputStream inputStream, String string) {
        return new CCJSqlParser(new StreamProvider(inputStream, string));
    }

    public static Node parseAST(String object) {
        object = CCJSqlParserUtil.newParser((String)object);
        try {
            ((CCJSqlParser)object).Statement();
            return ((CCJSqlParser)object).jjtree.rootNode();
        }
        catch (Exception exception) {
            throw new JSQLParserException(exception);
        }
    }

    public static Statement parse(InputStream inputStream) {
        try {
            return CCJSqlParserUtil.newParser(inputStream).Statement();
        }
        catch (Exception exception) {
            throw new JSQLParserException(exception);
        }
    }

    public static Statement parse(InputStream inputStream, String string) {
        try {
            return CCJSqlParserUtil.newParser(inputStream, string).Statement();
        }
        catch (Exception exception) {
            throw new JSQLParserException(exception);
        }
    }

    public static Expression parseExpression(String string) {
        return CCJSqlParserUtil.parseExpression(string, true);
    }

    public static Expression parseExpression(String string, boolean bl2) {
        return CCJSqlParserUtil.parseExpression(string, bl2, cCJSqlParser -> {});
    }

    public static Expression parseExpression(String string, boolean bl2, Consumer<CCJSqlParser> consumer) {
        Expression expression;
        block11: {
            expression = null;
            try {
                CCJSqlParser cCJSqlParser = (CCJSqlParser)CCJSqlParserUtil.newParser(string).withAllowComplexParsing(false);
                if (consumer != null) {
                    consumer.accept(cCJSqlParser);
                }
                try {
                    expression = cCJSqlParser.Expression();
                    if (cCJSqlParser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (ParseException parseException) {
                    throw new JSQLParserException(parseException);
                }
            }
            catch (JSQLParserException jSQLParserException) {
                if (CCJSqlParserUtil.getNestingDepth(string) > 10) break block11;
                CCJSqlParser cCJSqlParser = (CCJSqlParser)CCJSqlParserUtil.newParser(string).withAllowComplexParsing(true);
                if (consumer != null) {
                    consumer.accept(cCJSqlParser);
                }
                try {
                    expression = cCJSqlParser.Expression();
                    if (!bl2 && cCJSqlParser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (JSQLParserException jSQLParserException2) {
                    throw jSQLParserException2;
                }
                catch (ParseException parseException) {
                    throw new JSQLParserException(parseException);
                }
            }
        }
        return expression;
    }

    public static Expression parseCondExpression(String string) {
        return CCJSqlParserUtil.parseCondExpression(string, true);
    }

    public static Expression parseCondExpression(String string, boolean bl2) {
        return CCJSqlParserUtil.parseCondExpression(string, bl2, cCJSqlParser -> {});
    }

    public static Expression parseCondExpression(String string, boolean bl2, Consumer<CCJSqlParser> consumer) {
        Expression expression;
        block11: {
            expression = null;
            try {
                CCJSqlParser cCJSqlParser = (CCJSqlParser)CCJSqlParserUtil.newParser(string).withAllowComplexParsing(false);
                if (consumer != null) {
                    consumer.accept(cCJSqlParser);
                }
                try {
                    expression = cCJSqlParser.Expression();
                    if (cCJSqlParser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (ParseException parseException) {
                    throw new JSQLParserException(parseException);
                }
            }
            catch (JSQLParserException jSQLParserException) {
                if (CCJSqlParserUtil.getNestingDepth(string) > 10) break block11;
                CCJSqlParser cCJSqlParser = (CCJSqlParser)CCJSqlParserUtil.newParser(string).withAllowComplexParsing(true);
                if (consumer != null) {
                    consumer.accept(cCJSqlParser);
                }
                try {
                    expression = cCJSqlParser.Expression();
                    if (!bl2 && cCJSqlParser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (JSQLParserException jSQLParserException2) {
                    throw jSQLParserException2;
                }
                catch (ParseException parseException) {
                    throw new JSQLParserException(parseException);
                }
            }
        }
        return expression;
    }

    public static Statement parseStatement(CCJSqlParser cCJSqlParser, ExecutorService object) {
        Future<Statement> future = object.submit(new CCJSqlParserUtil$1(cCJSqlParser));
        try {
            object = future.get(cCJSqlParser.getConfiguration().getAsLong(Feature.timeOut), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            cCJSqlParser.interrupted = true;
            future.cancel(true);
            throw new JSQLParserException("Time out occurred.", timeoutException);
        }
        catch (Exception exception) {
            throw new JSQLParserException(exception);
        }
        return object;
    }

    public static Statements parseStatements(String string) {
        return CCJSqlParserUtil.parseStatements(string, null);
    }

    public static Statements parseStatements(String object, Consumer<CCJSqlParser> consumer) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        object = CCJSqlParserUtil.parseStatements((String)object, executorService, consumer);
        executorService.shutdown();
        return object;
    }

    public static Statements parseStatements(String string, ExecutorService executorService, Consumer<CCJSqlParser> consumer) {
        Statements statements;
        block4: {
            statements = null;
            CCJSqlParser cCJSqlParser = CCJSqlParserUtil.newParser(string);
            if (consumer != null) {
                consumer.accept(cCJSqlParser);
            }
            boolean bl2 = cCJSqlParser.getConfiguration().getAsBoolean(Feature.allowComplexParsing);
            try {
                statements = CCJSqlParserUtil.parseStatements((CCJSqlParser)cCJSqlParser.withAllowComplexParsing(false), executorService);
            }
            catch (JSQLParserException jSQLParserException) {
                if (!bl2 || CCJSqlParserUtil.getNestingDepth(string) > 10) break block4;
                cCJSqlParser = CCJSqlParserUtil.newParser(string);
                if (consumer != null) {
                    consumer.accept(cCJSqlParser);
                }
                statements = CCJSqlParserUtil.parseStatements((CCJSqlParser)cCJSqlParser.withAllowComplexParsing(true), executorService);
            }
        }
        return statements;
    }

    public static Statements parseStatements(CCJSqlParser cCJSqlParser, ExecutorService object) {
        Future<Statements> future = object.submit(new CCJSqlParserUtil$2(cCJSqlParser));
        try {
            object = future.get(cCJSqlParser.getConfiguration().getAsLong(Feature.timeOut), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            cCJSqlParser.interrupted = true;
            future.cancel(true);
            throw new JSQLParserException("Time out occurred.", timeoutException);
        }
        catch (Exception exception) {
            throw new JSQLParserException(exception);
        }
        return object;
    }

    public static void streamStatements(StatementListener statementListener, InputStream object, String object2) {
        try {
            object = CCJSqlParserUtil.newParser((InputStream)object, (String)object2);
            do {
                object2 = ((CCJSqlParser)object).SingleStatement();
                statementListener.accept((Statement)object2);
                if (((CCJSqlParser)object).getToken((int)1).kind != 344) continue;
                ((CCJSqlParser)object).getNextToken();
            } while (((CCJSqlParser)object).getToken((int)1).kind != 0);
            return;
        }
        catch (Exception exception) {
            throw new JSQLParserException(exception);
        }
    }

    public static int getNestingDepth(String object) {
        int n2 = 0;
        int n3 = 0;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n4 = cArray.length;
        block4: for (int i2 = 0; i2 < n4; ++i2) {
            switch (object[i2]) {
                case 40: {
                    ++n3;
                    continue block4;
                }
                case 41: {
                    if (n2 < n3) {
                        n2 = n3;
                    }
                    --n3;
                }
            }
        }
        return n2;
    }

    public static int getUnbalancedPosition(String string) {
        int n2;
        int n3;
        Stack<Character> stack = new Stack<Character>();
        boolean bl2 = false;
        for (n3 = 0; n3 < string.length(); ++n3) {
            n2 = string.charAt(n3);
            if (n2 == 34 || n2 == 39) {
                if (!bl2) {
                    stack.push(Character.valueOf((char)n2));
                } else if (((Character)stack.peek()).charValue() == n2) {
                    stack.pop();
                }
                bl2 = !bl2;
                continue;
            }
            if (!(bl2 || n2 != 40 && n2 != 91 && n2 != 123)) {
                stack.push(Character.valueOf((char)n2));
                continue;
            }
            if (bl2 || n2 != 41 && n2 != 93 && n2 != 125) continue;
            if (stack.isEmpty()) {
                return n3;
            }
            char c2 = ((Character)stack.pop()).charValue();
            if (!(n2 == 41 && c2 != '(' || n2 == 93 && c2 != '[') && (n2 != 125 || c2 == '{')) continue;
            return n3;
        }
        if (!stack.isEmpty()) {
            n3 = ((Character)stack.peek()).charValue();
            for (n2 = 0; n2 < string.length(); ++n2) {
                if (string.charAt(n2) != n3) continue;
                return n2;
            }
        }
        return -1;
    }

    static {
        LOGGER.setLevel(Level.OFF);
    }
}

