/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParserKeywordsUtils {
    public static final CharsetEncoder CHARSET_ENCODER = StandardCharsets.US_ASCII.newEncoder();
    public static final int RESTRICTED_FUNCTION = 1;
    public static final int RESTRICTED_SCHEMA = 2;
    public static final int RESTRICTED_TABLE = 4;
    public static final int RESTRICTED_COLUMN = 8;
    public static final int RESTRICTED_EXPRESSION = 16;
    public static final int RESTRICTED_ALIAS = 32;
    public static final int RESTRICTED_SQL2016 = 64;
    public static final int RESTRICTED_JSQLPARSER = 255;
    public static final Object[][] ALL_RESERVED_KEYWORDS = new Object[][]{{"ABSENT", 255}, {"ALL", 64}, {"AND", 64}, {"ANY", 255}, {"AS", 64}, {"BETWEEN", 64}, {"BOTH", 64}, {"CASEWHEN", 32}, {"CHECK", 64}, {"CONNECT", 32}, {"CONNECT_BY_ROOT", 255}, {"CONSTRAINT", 64}, {"CREATE", 32}, {"CROSS", 64}, {"CURRENT", 255}, {"DISTINCT", 64}, {"DOUBLE", 32}, {"ELSE", 255}, {"EXCEPT", 64}, {"EXISTS", 64}, {"FETCH", 64}, {"FINAL", 255}, {"FOR", 64}, {"FORCE", 64}, {"FOREIGN", 64}, {"FROM", 64}, {"FULL", 64}, {"GROUP", 64}, {"GROUPING", 32}, {"QUALIFY", 32}, {"HAVING", 64}, {"IF", 64}, {"IIF", 32}, {"IGNORE", 32}, {"ILIKE", 64}, {"IN", 64}, {"INNER", 64}, {"INTERSECT", 64}, {"INTERVAL", 64}, {"INTO", 255}, {"IS", 64}, {"JOIN", 255}, {"LATERAL", 64}, {"LEFT", 64}, {"LIKE", 64}, {"LIMIT", 64}, {"MINUS", 64}, {"NATURAL", 64}, {"NOCYCLE", 255}, {"NOT", 64}, {"NULL", 64}, {"OFFSET", 64}, {"ON", 64}, {"ONLY", 255}, {"OPTIMIZE", 32}, {"OR", 64}, {"ORDER", 64}, {"OUTER", 255}, {"OUTPUT", 255}, {"OPTIMIZE ", 255}, {"PIVOT", 255}, {"PROCEDURE", 32}, {"PUBLIC", 32}, {"RECURSIVE", 64}, {"REGEXP", 64}, {"RETURNING", 255}, {"RIGHT", 64}, {"SAMPLE", 32}, {"SEL", 32}, {"SELECT", 32}, {"SEMI", 255}, {"SET", 255}, {"SOME", 255}, {"START", 255}, {"TABLES", 32}, {"TOP", 64}, {"TRAILING", 64}, {"UNBOUNDED", 255}, {"UNION", 64}, {"UNIQUE", 64}, {"UNPIVOT", 255}, {"USE", 255}, {"USING", 64}, {"SQL_CACHE", 255}, {"SQL_CALC_FOUND_ROWS", 255}, {"SQL_NO_CACHE", 255}, {"STRAIGHT_JOIN", 255}, {"TABLESAMPLE", 32}, {"VALUE", 255}, {"VALUES", 64}, {"VARYING", 255}, {"WHEN", 64}, {"WHERE", 64}, {"WINDOW", 64}, {"WITH", 64}, {"XOR", 255}, {"XMLSERIALIZE", 255}, {"SEL", 255}, {"SELECT", 255}, {"DATE", 255}, {"TIME", 255}, {"TIMESTAMP", 255}, {"YEAR", 255}, {"MONTH", 255}, {"DAY", 255}, {"HOUR", 255}, {"MINUTE", 255}, {"SECOND", 255}, {"SUBSTR", 255}, {"SUBSTRING", 255}, {"TRIM", 255}, {"POSITION", 255}, {"OVERLAY", 255}, {"NEXTVAL", 255}, {"0x", 255}};

    public static List<String> getReservedKeywords(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[][] objectArray = ALL_RESERVED_KEYWORDS;
        int n3 = ALL_RESERVED_KEYWORDS.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object[] objectArray2 = objectArray[i2];
            int n4 = (Integer)objectArray2[1];
            if ((n4 & n2) != n2 && (n2 & n4) != n4) continue;
            arrayList.add((String)objectArray2[0]);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("No filename provided as parameters ARGS[0]");
        }
        File file = new File(stringArray[0]);
        if (!(file.exists() && file.canRead() && file.canWrite())) {
            throw new FileNotFoundException("Can't read file " + stringArray[0]);
        }
        ParserKeywordsUtils.buildGrammarForRelObjectName(file);
        ParserKeywordsUtils.buildGrammarForRelObjectNameWithoutValue(file);
        file = new File(stringArray[1]);
        file.createNewFile();
        if (file.canWrite()) {
            ParserKeywordsUtils.writeKeywordsDocumentationFile(file);
            return;
        }
        throw new FileNotFoundException("Can't read file " + stringArray[1]);
    }

    public static TreeSet<String> getAllKeywordsUsingRegex(File object) {
        Object object2 = Pattern.compile("TOKEN\\s*:\\s*(?:/\\*.*\\*/*)\\n\\{(?:[^\\}\\{]+|\\{(?:[^\\}\\{]+|\\{[^\\}\\{]*\\})*\\})*\\}", 8);
        Pattern pattern = Pattern.compile("\\\"(\\w{2,})\\\"", 8);
        TreeSet<String> treeSet = new TreeSet<String>();
        object = ((File)object).toPath();
        Object object3 = Charset.defaultCharset();
        object = new String(Files.readAllBytes((Path)object), (Charset)object3);
        object = ((Pattern)object2).matcher((CharSequence)object);
        while (((Matcher)object).find()) {
            object2 = ((Matcher)object).group(0);
            object2 = pattern.matcher((CharSequence)object2);
            while (((Matcher)object2).find()) {
                object3 = ((Matcher)object2).group(1);
                if (!CHARSET_ENCODER.canEncode((CharSequence)object3) || !((String)object3).matches("[A-Za-z]+")) continue;
                treeSet.add((String)object3);
            }
        }
        return treeSet;
    }

    public static void buildGrammarForRelObjectNameWithoutValue(File file) {
        Pattern pattern = Pattern.compile("String\\W*RelObjectNameWithoutValue\\W*\\(\\W*\\)\\W*:\\s*\\{(?:[^}{]+|\\{(?:[^}{]+|\\{[^}{]*})*})*}\\s*\\{(?:[^}{]+|\\{(?:[^}{]+|\\{[^}{]*})*})*}", 8);
        Object object2 = ParserKeywordsUtils.getAllKeywords(file);
        for (String object3 : ParserKeywordsUtils.getReservedKeywords(255)) {
            ((TreeSet)object2).remove(object3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("String RelObjectNameWithoutValue() :\n{    Token tk = null; }\n{\n    ( tk=<S_IDENTIFIER> | tk=<S_QUOTED_IDENTIFIER> |  tk=<K_DATE_LITERAL> | tk=<K_DATETIMELITERAL> | tk=<K_STRING_FUNCTION_NAME> | tk=<K_ISOLATION> | tk=<K_TIME_KEY_EXPR> \n      ");
        Iterator<String> iterator = ((TreeSet)object2).iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            stringBuilder.append(" | tk=\"").append((String)object2).append("\"");
        }
        stringBuilder.append(" )\n    { return tk.image; }\n}");
        ParserKeywordsUtils.replaceInFile(file, pattern, stringBuilder.toString());
    }

    public static void buildGrammarForRelObjectName(File object) {
        object = new TreeSet<String>();
        for (String object22 : ParserKeywordsUtils.getReservedKeywords(32)) {
            ((TreeSet)object).add(object22);
        }
        for (String string : ParserKeywordsUtils.getReservedKeywords(223)) {
            ((TreeSet)object).remove(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("String RelObjectName() :\n{    Token tk = null; String result = null; }\n{\n    (result = RelObjectNameWithoutValue()\n      ");
        Iterator iterator = ((TreeSet)object).iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringBuilder.append(" | tk=\"").append((String)object).append("\"");
        }
        stringBuilder.append(" )\n    { return tk!=null ? tk.image : result; }\n}");
    }

    public static TreeSet<String> getAllKeywords(File file) {
        return ParserKeywordsUtils.getAllKeywordsUsingRegex(file);
    }

    private static void replaceInFile(File file, Pattern pattern, String string) {
        Object object = file.toPath();
        Charset charset = Charset.defaultCharset();
        object = new String(Files.readAllBytes((Path)object), charset);
        object = pattern.matcher((CharSequence)object).replaceAll(string);
        Files.write(file.toPath(), ((String)object).getBytes(charset), new OpenOption[0]);
    }

    public static String rightPadding(String string, char c2, int n2) {
        return String.format("%" + -n2 + "s", string).replace(' ', c2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeKeywordsDocumentationFile(File file) {
        Object object;
        block10: {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("***********************\n");
            stringBuilder.append("Restricted Keywords\n");
            stringBuilder.append("***********************\n");
            stringBuilder.append("\n");
            stringBuilder.append("The following Keywords are **restricted** in JSQLParser-|JSQLPARSER_VERSION| and must not be used for **Naming Objects**: \n");
            stringBuilder.append("\n");
            stringBuilder.append("+----------------------+-------------+-----------+\n");
            stringBuilder.append("| **Keyword**          | JSQL Parser | SQL:2016  |\n");
            stringBuilder.append("+----------------------+-------------+-----------+\n");
            object = ALL_RESERVED_KEYWORDS;
            int n2 = ALL_RESERVED_KEYWORDS.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object[] objectArray = object[i2];
                stringBuilder.append("| ").append(ParserKeywordsUtils.rightPadding(objectArray[0].toString(), ' ', 20)).append(" | ");
                int n3 = (Integer)objectArray[1];
                String string = (n3 & 0xFF) == 255 || (0xFF & n3) == n3 ? "Yes" : "";
                stringBuilder.append(ParserKeywordsUtils.rightPadding(string, ' ', 11)).append(" | ");
                string = (n3 & 0x40) == 64 || (0x40 & n3) == n3 ? "Yes" : "";
                stringBuilder.append(ParserKeywordsUtils.rightPadding(string, ' ', 9)).append(" | ");
                stringBuilder.append("\n");
                stringBuilder.append("+----------------------+-------------+-----------+\n");
            }
            object = new FileWriter(file);
            Throwable throwable = null;
            try {
                ((OutputStreamWriter)object).append(stringBuilder);
                ((OutputStreamWriter)object).flush();
                if (throwable == null) break block10;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable4 = throwable2;
                    throwable = throwable2;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        ((OutputStreamWriter)object).close();
                        throw throwable5;
                    }
                    try {
                        ((OutputStreamWriter)object).close();
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                        throw throwable5;
                    }
                }
            }
            try {
                ((OutputStreamWriter)object).close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        ((OutputStreamWriter)object).close();
    }
}

