/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.create.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;

public class AlterView
implements Statement {
    private Table view;
    private Select select;
    private boolean useReplace = false;
    private List<String> columnNames = null;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getView() {
        return this.view;
    }

    public void setView(Table table) {
        this.view = table;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> list) {
        this.columnNames = list;
    }

    public boolean isUseReplace() {
        return this.useReplace;
    }

    public void setUseReplace(boolean bl2) {
        this.useReplace = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = this.useReplace ? new StringBuilder("REPLACE ") : new StringBuilder("ALTER ");
        stringBuilder.append("VIEW ");
        stringBuilder.append(this.view);
        if (this.columnNames != null) {
            stringBuilder.append(PlainSelect.getStringList(this.columnNames, true, true));
        }
        stringBuilder.append(" AS ").append(this.select);
        return stringBuilder.toString();
    }

    public AlterView withView(Table table) {
        this.setView(table);
        return this;
    }

    public AlterView withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public AlterView withUseReplace(boolean bl2) {
        this.setUseReplace(bl2);
        return this;
    }

    public AlterView withColumnNames(List<String> list) {
        this.setColumnNames(list);
        return this;
    }

    public AlterView addColumnNames(String ... stringArray) {
        List list = Optional.ofNullable(this.getColumnNames()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withColumnNames(list);
    }

    public AlterView addColumnNames(Collection<String> collection) {
        List list = Optional.ofNullable(this.getColumnNames()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withColumnNames(list);
    }

    public <E extends Select> E getSelectBody(Class<E> clazz) {
        return (E)((Select)clazz.cast(this.getSelect()));
    }
}

