/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Fetch;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ForClause;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Limit;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Offset;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Values;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithIsolation;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;

public abstract class Select
extends ASTNodeAccessImpl
implements Expression,
Statement {
    List<WithItem> withItemsList;
    Limit limitBy;
    Limit limit;
    Offset offset;
    Fetch fetch;
    WithIsolation isolation;
    boolean oracleSiblings = false;
    ForClause forClause = null;
    List<OrderByElement> orderByElements;

    public static String orderByToString(List<OrderByElement> list) {
        return Select.orderByToString(false, list);
    }

    public static String orderByToString(boolean bl2, List<OrderByElement> list) {
        return Select.getFormattedList(list, bl2 ? "ORDER SIBLINGS BY" : "ORDER BY");
    }

    public static String getFormattedList(List<?> list, String string) {
        return Select.getFormattedList(list, string, true, false);
    }

    public static String getFormattedList(List<?> object, String string, boolean bl2, boolean bl3) {
        if (((String)(object = Select.getStringList(object, bl2, bl3))).length() > 0) {
            object = string.length() > 0 ? " " + string + " " + (String)object : " ".concat(String.valueOf(object));
        }
        return object;
    }

    public static String getStringList(List<?> list) {
        return Select.getStringList(list, true, false);
    }

    public static String getStringList(List<?> list, boolean bl2, boolean bl3) {
        return Select.appendStringListTo(new StringBuilder(), list, bl2, bl3).toString();
    }

    public static StringBuilder appendStringListTo(StringBuilder stringBuilder, List<?> list, boolean bl2, boolean bl3) {
        if (list != null) {
            String string;
            String string2 = string = bl2 ? ", " : " ";
            if (bl3) {
                stringBuilder.append("(");
            }
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(list.get(i2)).append(i2 < n2 - 1 ? string : "");
            }
            if (bl3) {
                stringBuilder.append(")");
            }
        }
        return stringBuilder;
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> list) {
        this.withItemsList = list;
    }

    public Select withWithItemsList(List<WithItem> list) {
        this.setWithItemsList(list);
        return this;
    }

    public Select addWithItemsList(Collection<? extends WithItem> collection) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withWithItemsList(list);
    }

    public Select addWithItemsList(WithItem ... withItemArray) {
        return this.addWithItemsList(Arrays.asList(withItemArray));
    }

    public boolean isOracleSiblings() {
        return this.oracleSiblings;
    }

    public void setOracleSiblings(boolean bl2) {
        this.oracleSiblings = bl2;
    }

    public Select withOracleSiblings(boolean bl2) {
        this.setOracleSiblings(bl2);
        return this;
    }

    public ForClause getForClause() {
        return this.forClause;
    }

    public Select setForClause(ForClause forClause) {
        this.forClause = forClause;
        return this;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public Select withOrderByElements(List<OrderByElement> list) {
        this.setOrderByElements(list);
        return this;
    }

    public Select addOrderByElements(Collection<? extends OrderByElement> collection) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withOrderByElements(list);
    }

    public Select addOrderByElements(OrderByElement ... orderByElementArray) {
        return this.addOrderByElements(Arrays.asList(orderByElementArray));
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Select withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public Limit getLimitBy() {
        return this.limitBy;
    }

    public void setLimitBy(Limit limit) {
        this.limitBy = limit;
    }

    public <E extends Select> E withLimitBy(Class<E> clazz, Limit limit) {
        this.setLimitBy(limit);
        return (E)((Select)clazz.cast(this));
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Select withOffset(Offset offset) {
        this.setOffset(offset);
        return this;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public Select withFetch(Fetch fetch) {
        this.setFetch(fetch);
        return this;
    }

    public WithIsolation getIsolation() {
        return this.isolation;
    }

    public void setIsolation(WithIsolation withIsolation) {
        this.isolation = withIsolation;
    }

    public Select withIsolation(WithIsolation withIsolation) {
        this.setIsolation(withIsolation);
        return this;
    }

    public abstract StringBuilder appendSelectBodyTo(StringBuilder var1);

    @Override
    public StringBuilder appendTo(StringBuilder stringBuilder) {
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            stringBuilder.append("WITH ");
            Iterator<WithItem> iterator = this.withItemsList.iterator();
            while (iterator.hasNext()) {
                WithItem withItem = iterator.next();
                stringBuilder.append(withItem);
                if (iterator.hasNext()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(" ");
            }
        }
        this.appendSelectBodyTo(stringBuilder);
        if (this.forClause != null) {
            this.forClause.appendTo(stringBuilder);
        }
        stringBuilder.append(Select.orderByToString(this.oracleSiblings, this.orderByElements));
        if (this.limitBy != null) {
            stringBuilder.append(this.limitBy);
        }
        if (this.limit != null) {
            stringBuilder.append(this.limit);
        }
        if (this.offset != null) {
            stringBuilder.append(this.offset);
        }
        if (this.fetch != null) {
            stringBuilder.append(this.fetch);
        }
        if (this.isolation != null) {
            stringBuilder.append(this.isolation);
        }
        return stringBuilder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public abstract void accept(SelectVisitor var1);

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    @Deprecated
    public Select getSelectBody() {
        return this;
    }

    public Values getValues() {
        return (Values)this;
    }

    public PlainSelect getPlainSelect() {
        return (PlainSelect)this;
    }

    public SetOperationList getSetOperationList() {
        return (SetOperationList)this;
    }

    public <E extends Select> E as(Class<E> clazz) {
        return (E)((Select)clazz.cast(this));
    }
}

