/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.LateralSubSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Values;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;

public class AddAliasesVisitor
implements SelectItemVisitor,
SelectVisitor {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";
    private List<String> aliases = new LinkedList<String>();
    private boolean firstRun = true;
    private int counter = 0;
    private String prefix = "A";

    @Override
    public void visit(ParenthesedSelect parenthesedSelect) {
        parenthesedSelect.getSelect().accept(this);
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        this.firstRun = true;
        this.counter = 0;
        this.aliases.clear();
        Iterator<SelectItem<?>> iterator = plainSelect.getSelectItems().iterator();
        while (iterator.hasNext()) {
            iterator.next().accept(this);
        }
        this.firstRun = false;
        iterator = plainSelect.getSelectItems().iterator();
        while (iterator.hasNext()) {
            iterator.next().accept(this);
        }
    }

    @Override
    public void visit(SetOperationList object) {
        object = ((SetOperationList)object).getSelects().iterator();
        while (object.hasNext()) {
            ((Select)object.next()).accept(this);
        }
    }

    @Override
    public void visit(SelectItem selectItem) {
        if (this.firstRun) {
            if (selectItem.getAlias() != null) {
                this.aliases.add(selectItem.getAlias().getName().toUpperCase());
                return;
            }
        } else if (selectItem.getAlias() == null) {
            String string;
            while (this.aliases.contains(string = this.getNextAlias().toUpperCase())) {
            }
            this.aliases.add(string);
            selectItem.setAlias(new Alias(string));
            return;
        }
    }

    protected String getNextAlias() {
        ++this.counter;
        return this.prefix + this.counter;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    @Override
    public void visit(WithItem withItem) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(Values values) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        lateralSubSelect.getSelect().accept(this);
    }
}

