/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.expression.AllValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.AnalyticExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.AnalyticType;
import liquibase.repackaged.net.sf.jsqlparser.expression.AnyComparisonExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ArrayConstructor;
import liquibase.repackaged.net.sf.jsqlparser.expression.ArrayExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.BinaryExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.CaseExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.CastExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.CollateExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ConnectByRootOperator;
import liquibase.repackaged.net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.DateValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.DoubleValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExtractExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.Function;
import liquibase.repackaged.net.sf.jsqlparser.expression.HexValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.IntervalExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.JdbcNamedParameter;
import liquibase.repackaged.net.sf.jsqlparser.expression.JdbcParameter;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonAggregateFunction;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonFunction;
import liquibase.repackaged.net.sf.jsqlparser.expression.KeepExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.LongValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.MySQLGroupConcat;
import liquibase.repackaged.net.sf.jsqlparser.expression.NextValExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.NotExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.NullValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.NumericBind;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleNamedFunctionParameter;
import liquibase.repackaged.net.sf.jsqlparser.expression.OverlapsCondition;
import liquibase.repackaged.net.sf.jsqlparser.expression.Parenthesis;
import liquibase.repackaged.net.sf.jsqlparser.expression.RangeExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.RowConstructor;
import liquibase.repackaged.net.sf.jsqlparser.expression.RowGetExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.SignedExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.StringValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimeKeyExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimeValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimestampValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimezoneExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.TranscodingFunction;
import liquibase.repackaged.net.sf.jsqlparser.expression.TrimFunction;
import liquibase.repackaged.net.sf.jsqlparser.expression.UserVariable;
import liquibase.repackaged.net.sf.jsqlparser.expression.VariableAssignment;
import liquibase.repackaged.net.sf.jsqlparser.expression.WhenClause;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowElement;
import liquibase.repackaged.net.sf.jsqlparser.expression.XMLSerializeExpr;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Division;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.IntegerDivision;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.conditional.XorExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.Between;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.FullTextSearch;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.GeometryDistance;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.InExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.IsDistinctExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.Matches;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MemberOfExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MinorThan;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllTableColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ExpressionListDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class ExpressionDeParser
extends AbstractDeParser<Expression>
implements ExpressionVisitor {
    private static final String NOT = "NOT ";
    private SelectVisitor selectVisitor;
    private OrderByDeParser orderByDeParser = new OrderByDeParser();

    public ExpressionDeParser() {
        super(new StringBuilder());
    }

    public ExpressionDeParser(SelectVisitor selectVisitor, StringBuilder stringBuilder) {
        this(selectVisitor, stringBuilder, new OrderByDeParser());
    }

    ExpressionDeParser(SelectVisitor selectVisitor, StringBuilder stringBuilder, OrderByDeParser orderByDeParser) {
        super(stringBuilder);
        this.selectVisitor = selectVisitor;
        this.orderByDeParser = orderByDeParser;
    }

    @Override
    public void visit(Addition addition) {
        this.visitBinaryExpression(addition, " + ");
    }

    @Override
    public void visit(AndExpression andExpression) {
        AndExpression andExpression2 = andExpression;
        this.visitBinaryExpression(andExpression2, andExpression2.isUseOperator() ? " && " : " AND ");
    }

    @Override
    public void visit(Between between) {
        between.getLeftExpression().accept(this);
        if (between.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" BETWEEN ");
        between.getBetweenExpressionStart().accept(this);
        this.buffer.append(" AND ");
        between.getBetweenExpressionEnd().accept(this);
    }

    @Override
    public void visit(OverlapsCondition overlapsCondition) {
        this.buffer.append(overlapsCondition.toString());
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visitOldOracleJoinBinaryExpression(equalsTo, " = ");
    }

    @Override
    public void visit(Division division) {
        this.visitBinaryExpression(division, " / ");
    }

    @Override
    public void visit(IntegerDivision integerDivision) {
        this.visitBinaryExpression(integerDivision, " DIV ");
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.buffer.append(doubleValue.toString());
    }

    @Override
    public void visit(HexValue hexValue) {
        this.buffer.append(hexValue.toString());
    }

    @Override
    public void visit(NotExpression notExpression) {
        if (notExpression.isExclamationMark()) {
            this.buffer.append("! ");
        } else {
            this.buffer.append(NOT);
        }
        notExpression.getExpression().accept(this);
    }

    @Override
    public void visit(BitwiseRightShift bitwiseRightShift) {
        this.visitBinaryExpression(bitwiseRightShift, " >> ");
    }

    @Override
    public void visit(BitwiseLeftShift bitwiseLeftShift) {
        this.visitBinaryExpression(bitwiseLeftShift, " << ");
    }

    public void visitOldOracleJoinBinaryExpression(OldOracleJoinBinaryExpression oldOracleJoinBinaryExpression, String string) {
        oldOracleJoinBinaryExpression.getLeftExpression().accept(this);
        if (oldOracleJoinBinaryExpression.getOldOracleJoinSyntax() == 1) {
            this.buffer.append("(+)");
        }
        this.buffer.append(string);
        oldOracleJoinBinaryExpression.getRightExpression().accept(this);
        if (oldOracleJoinBinaryExpression.getOldOracleJoinSyntax() == 2) {
            this.buffer.append("(+)");
        }
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        this.visitOldOracleJoinBinaryExpression(greaterThan, " > ");
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitOldOracleJoinBinaryExpression(greaterThanEquals, " >= ");
    }

    @Override
    public void visit(InExpression inExpression) {
        inExpression.getLeftExpression().accept(this);
        if (inExpression.getOldOracleJoinSyntax() == 1) {
            this.buffer.append("(+)");
        }
        if (inExpression.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" IN ");
        inExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(FullTextSearch fullTextSearch) {
        String string = "";
        Iterator iterator = fullTextSearch.getMatchColumns().iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            string = string + column.getFullyQualifiedName();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        this.buffer.append("MATCH (" + string + ") AGAINST (" + fullTextSearch.getAgainstValue() + (fullTextSearch.getSearchModifier() != null ? " " + fullTextSearch.getSearchModifier() : "") + ")");
    }

    @Override
    public void visit(SignedExpression signedExpression) {
        this.buffer.append(signedExpression.getSign());
        signedExpression.getExpression().accept(this);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        isNullExpression.getLeftExpression().accept(this);
        if (isNullExpression.isUseNotNull()) {
            this.buffer.append(" NOTNULL");
            return;
        }
        if (isNullExpression.isUseIsNull()) {
            if (isNullExpression.isNot()) {
                this.buffer.append(" NOT ISNULL");
                return;
            }
            this.buffer.append(" ISNULL");
            return;
        }
        if (isNullExpression.isNot()) {
            this.buffer.append(" IS NOT NULL");
            return;
        }
        this.buffer.append(" IS NULL");
    }

    @Override
    public void visit(IsBooleanExpression isBooleanExpression) {
        isBooleanExpression.getLeftExpression().accept(this);
        if (isBooleanExpression.isTrue()) {
            if (isBooleanExpression.isNot()) {
                this.buffer.append(" IS NOT TRUE");
                return;
            }
            this.buffer.append(" IS TRUE");
            return;
        }
        if (isBooleanExpression.isNot()) {
            this.buffer.append(" IS NOT FALSE");
            return;
        }
        this.buffer.append(" IS FALSE");
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.buffer.append("?");
        if (jdbcParameter.isUseFixedIndex()) {
            this.buffer.append(jdbcParameter.getIndex());
        }
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        likeExpression.getLeftExpression().accept(this);
        this.buffer.append(" ");
        if (likeExpression.isNot()) {
            this.buffer.append(NOT);
        }
        this.buffer.append((Object)likeExpression.getLikeKeyWord()).append(" ");
        if (likeExpression.isUseBinary()) {
            this.buffer.append("BINARY ");
        }
        likeExpression.getRightExpression().accept(this);
        if (likeExpression.getEscape() != null) {
            this.buffer.append(" ESCAPE ");
            likeExpression.getEscape().accept(this);
        }
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        if (existsExpression.isNot()) {
            this.buffer.append("NOT EXISTS ");
        } else {
            this.buffer.append("EXISTS ");
        }
        existsExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(MemberOfExpression memberOfExpression) {
        memberOfExpression.getLeftExpression().accept(this);
        if (memberOfExpression.isNot()) {
            this.buffer.append(" NOT MEMBER OF ");
        } else {
            this.buffer.append(" MEMBER OF ");
        }
        memberOfExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(LongValue longValue) {
        this.buffer.append(longValue.getStringValue());
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visitOldOracleJoinBinaryExpression(minorThan, " < ");
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visitOldOracleJoinBinaryExpression(minorThanEquals, " <= ");
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression(multiplication, " * ");
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visitOldOracleJoinBinaryExpression(notEqualsTo, " " + notEqualsTo.getStringExpression() + " ");
    }

    @Override
    public void visit(NullValue nullValue) {
        this.buffer.append(nullValue.toString());
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression, " OR ");
    }

    @Override
    public void visit(XorExpression xorExpression) {
        this.visitBinaryExpression(xorExpression, " XOR ");
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        this.buffer.append("(");
        parenthesis.getExpression().accept(this);
        this.buffer.append(")");
    }

    @Override
    public void visit(StringValue stringValue) {
        if (stringValue.getPrefix() != null) {
            this.buffer.append(stringValue.getPrefix());
        }
        this.buffer.append("'").append(stringValue.getValue()).append("'");
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression(subtraction, " - ");
    }

    protected void visitBinaryExpression(BinaryExpression binaryExpression, String string) {
        binaryExpression.getLeftExpression().accept(this);
        this.buffer.append(string);
        binaryExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(Select select) {
        if (this.selectVisitor != null) {
            if (select.getWithItemsList() != null) {
                this.buffer.append("WITH ");
                Iterator<WithItem> iterator = select.getWithItemsList().iterator();
                while (iterator.hasNext()) {
                    iterator.next().accept(this.selectVisitor);
                    if (iterator.hasNext()) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append(" ");
                }
                this.buffer.append(" ");
            }
            select.accept(this.selectVisitor);
        }
    }

    @Override
    public void visit(TranscodingFunction transcodingFunction) {
        this.buffer.append("CONVERT( ");
        transcodingFunction.getExpression().accept(this);
        this.buffer.append(" USING ").append(transcodingFunction.getTranscodingName()).append(" )");
    }

    @Override
    public void visit(TrimFunction trimFunction) {
        this.buffer.append("Trim(");
        if (trimFunction.getTrimSpecification() != null) {
            this.buffer.append(" ").append((Object)trimFunction.getTrimSpecification());
        }
        if (trimFunction.getExpression() != null) {
            this.buffer.append(" ");
            trimFunction.getExpression().accept(this);
        }
        if (trimFunction.getFromExpression() != null) {
            this.buffer.append(trimFunction.isUsingFromKeyword() ? " FROM " : ", ");
            trimFunction.getFromExpression().accept(this);
        }
        this.buffer.append(" )");
    }

    @Override
    public void visit(RangeExpression rangeExpression) {
        rangeExpression.getStartExpression().accept(this);
        this.buffer.append(":");
        rangeExpression.getEndExpression().accept(this);
    }

    @Override
    public void visit(Column column) {
        Table table = column.getTable();
        String string = null;
        if (table != null) {
            string = table.getAlias() != null ? table.getAlias().getName() : table.getFullyQualifiedName();
        }
        if (string != null && !string.isEmpty()) {
            this.buffer.append(string).append(".");
        }
        this.buffer.append(column.getColumnName());
        if (column.getArrayConstructor() != null) {
            column.getArrayConstructor().accept(this);
        }
    }

    @Override
    public void visit(Function function) {
        if (function.isEscaped()) {
            this.buffer.append("{fn ");
        }
        this.buffer.append(function.getName());
        if (function.getParameters() == null && function.getNamedParameters() == null) {
            this.buffer.append("()");
        } else {
            this.buffer.append("(");
            if (function.isDistinct()) {
                this.buffer.append("DISTINCT ");
            } else if (function.isAllColumns()) {
                this.buffer.append("ALL ");
            } else if (function.isUnique()) {
                this.buffer.append("UNIQUE ");
            }
            if (function.getNamedParameters() != null) {
                function.getNamedParameters().accept(this);
            }
            if (function.getParameters() != null) {
                function.getParameters().accept(this);
            }
            if (function.getOrderByElements() != null) {
                this.buffer.append(" ORDER BY ");
                boolean bl2 = false;
                this.orderByDeParser.setExpressionVisitor(this);
                this.orderByDeParser.setBuffer(this.buffer);
                for (OrderByElement orderByElement : function.getOrderByElements()) {
                    if (bl2) {
                        this.buffer.append(", ");
                    } else {
                        bl2 = true;
                    }
                    this.orderByDeParser.deParseElement(orderByElement);
                }
            }
            this.buffer.append(")");
        }
        if (function.getAttribute() != null) {
            this.buffer.append(".").append(function.getAttribute());
        }
        if (function.getKeep() != null) {
            this.buffer.append(" ").append(function.getKeep());
        }
        if (function.isEscaped()) {
            this.buffer.append("}");
        }
    }

    @Override
    public void visit(ParenthesedSelect parenthesedSelect) {
        parenthesedSelect.getSelect().accept(this);
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void visit(DateValue dateValue) {
        this.buffer.append("{d '").append(dateValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.buffer.append("{ts '").append(timestampValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.buffer.append("{t '").append(timeValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        this.buffer.append(caseExpression.isUsingBrackets() ? "(" : "").append("CASE ");
        Object object = caseExpression.getSwitchExpression();
        if (object != null) {
            object.accept(this);
            this.buffer.append(" ");
        }
        object = caseExpression.getWhenClauses().iterator();
        while (object.hasNext()) {
            ((Expression)object.next()).accept(this);
        }
        object = caseExpression.getElseExpression();
        if (object != null) {
            this.buffer.append("ELSE ");
            object.accept(this);
            this.buffer.append(" ");
        }
        this.buffer.append("END").append(caseExpression.isUsingBrackets() ? ")" : "");
    }

    @Override
    public void visit(WhenClause whenClause) {
        this.buffer.append("WHEN ");
        whenClause.getWhenExpression().accept(this);
        this.buffer.append(" THEN ");
        whenClause.getThenExpression().accept(this);
        this.buffer.append(" ");
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        this.buffer.append(anyComparisonExpression.getAnyType().name());
        anyComparisonExpression.getSelect().accept(this);
    }

    @Override
    public void visit(Concat concat) {
        this.visitBinaryExpression(concat, " || ");
    }

    @Override
    public void visit(Matches matches) {
        this.visitOldOracleJoinBinaryExpression(matches, " @@ ");
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression(bitwiseAnd, " & ");
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression(bitwiseOr, " | ");
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression(bitwiseXor, " ^ ");
    }

    @Override
    public void visit(CastExpression castExpression) {
        if (castExpression.isUseCastKeyword()) {
            this.buffer.append(castExpression.keyword).append("(");
            castExpression.getLeftExpression().accept(this);
            this.buffer.append(" AS ");
            this.buffer.append(castExpression.getColumnDefinitions().size() > 1 ? "ROW(" + Select.getStringList(castExpression.getColumnDefinitions()) + ")" : castExpression.getColDataType().toString());
            this.buffer.append(")");
            return;
        }
        castExpression.getLeftExpression().accept(this);
        this.buffer.append("::");
        this.buffer.append(castExpression.getColDataType());
    }

    @Override
    public void visit(Modulo modulo) {
        this.visitBinaryExpression(modulo, " % ");
    }

    @Override
    public void visit(AnalyticExpression analyticExpression) {
        Object object = analyticExpression.getName();
        Expression expression = analyticExpression.getExpression();
        Expression expression2 = analyticExpression.getOffset();
        Expression expression3 = analyticExpression.getDefaultValue();
        boolean bl2 = analyticExpression.isAllColumns();
        KeepExpression keepExpression = analyticExpression.getKeep();
        ExpressionList expressionList = analyticExpression.getPartitionExpressionList();
        List<OrderByElement> list = analyticExpression.getOrderByElements();
        WindowElement windowElement = analyticExpression.getWindowElement();
        this.buffer.append((String)object).append("(");
        if (analyticExpression.isDistinct()) {
            this.buffer.append("DISTINCT ");
        }
        if (analyticExpression.isUnique()) {
            this.buffer.append("UNIQUE ");
        }
        if (expression != null) {
            expression.accept(this);
            if (expression2 != null) {
                this.buffer.append(", ");
                expression2.accept(this);
                if (expression3 != null) {
                    this.buffer.append(", ");
                    expression3.accept(this);
                }
            }
        } else if (bl2) {
            this.buffer.append("*");
        }
        if (analyticExpression.isIgnoreNulls()) {
            this.buffer.append(" IGNORE NULLS");
        }
        if (analyticExpression.getFuncOrderBy() != null) {
            this.buffer.append(" ORDER BY ");
            this.buffer.append(analyticExpression.getFuncOrderBy().stream().map(OrderByElement::toString).collect(Collectors.joining(", ")));
        }
        this.buffer.append(") ");
        if (keepExpression != null) {
            keepExpression.accept(this);
            this.buffer.append(" ");
        }
        if (analyticExpression.getFilterExpression() != null) {
            this.buffer.append("FILTER (WHERE ");
            analyticExpression.getFilterExpression().accept(this);
            this.buffer.append(")");
            if (analyticExpression.getType() != AnalyticType.FILTER_ONLY) {
                this.buffer.append(" ");
            }
        }
        if (analyticExpression.isIgnoreNullsOutside()) {
            this.buffer.append("IGNORE NULLS ");
        }
        switch (analyticExpression.getType()) {
            case FILTER_ONLY: {
                return;
            }
            case WITHIN_GROUP: {
                this.buffer.append("WITHIN GROUP");
                break;
            }
            case WITHIN_GROUP_OVER: {
                this.buffer.append("WITHIN GROUP (");
                analyticExpression.getWindowDefinition().getOrderBy().toStringOrderByElements(this.buffer);
                this.buffer.append(") OVER (");
                analyticExpression.getWindowDefinition().getPartitionBy().toStringPartitionBy(this.buffer);
                this.buffer.append(")");
                break;
            }
            default: {
                this.buffer.append("OVER");
            }
        }
        if (analyticExpression.getWindowName() != null) {
            this.buffer.append(" ").append(analyticExpression.getWindowName());
            return;
        }
        if (analyticExpression.getType() != AnalyticType.WITHIN_GROUP_OVER) {
            this.buffer.append(" (");
            if (expressionList != null && !expressionList.getExpressions().isEmpty()) {
                this.buffer.append("PARTITION BY ");
                if (analyticExpression.isPartitionByBrackets()) {
                    this.buffer.append("(");
                }
                object = expressionList.getExpressions();
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    if (i2 > 0) {
                        this.buffer.append(", ");
                    }
                    ((Expression)object.get(i2)).accept(this);
                }
                if (analyticExpression.isPartitionByBrackets()) {
                    this.buffer.append(")");
                }
                this.buffer.append(" ");
            }
            if (list != null && !list.isEmpty()) {
                this.buffer.append("ORDER BY ");
                this.orderByDeParser.setExpressionVisitor(this);
                this.orderByDeParser.setBuffer(this.buffer);
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    if (i3 > 0) {
                        this.buffer.append(", ");
                    }
                    this.orderByDeParser.deParseElement(list.get(i3));
                }
            }
            if (windowElement != null) {
                if (list != null && !list.isEmpty()) {
                    this.buffer.append(' ');
                }
                this.buffer.append(windowElement);
            }
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(ExtractExpression extractExpression) {
        this.buffer.append("EXTRACT(").append(extractExpression.getName());
        this.buffer.append(" FROM ");
        extractExpression.getExpression().accept(this);
        this.buffer.append(')');
    }

    @Override
    public void visit(IntervalExpression intervalExpression) {
        if (intervalExpression.isUsingIntervalKeyword()) {
            this.buffer.append("INTERVAL ");
        }
        if (intervalExpression.getExpression() != null) {
            intervalExpression.getExpression().accept(this);
        } else {
            this.buffer.append(intervalExpression.getParameter());
        }
        if (intervalExpression.getIntervalType() != null) {
            this.buffer.append(" ").append(intervalExpression.getIntervalType());
        }
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        this.buffer.append(jdbcNamedParameter.toString());
    }

    @Override
    public void visit(OracleHierarchicalExpression oracleHierarchicalExpression) {
        this.buffer.append(oracleHierarchicalExpression.toString());
    }

    @Override
    public void visit(RegExpMatchOperator regExpMatchOperator) {
        this.visitBinaryExpression(regExpMatchOperator, " " + regExpMatchOperator.getStringExpression() + " ");
    }

    @Override
    public void visit(JsonExpression jsonExpression) {
        this.buffer.append(jsonExpression.toString());
    }

    @Override
    public void visit(JsonOperator jsonOperator) {
        this.visitBinaryExpression(jsonOperator, " " + jsonOperator.getStringExpression() + " ");
    }

    @Override
    public void visit(UserVariable userVariable) {
        this.buffer.append(userVariable.toString());
    }

    @Override
    public void visit(NumericBind numericBind) {
        this.buffer.append(numericBind.toString());
    }

    @Override
    public void visit(KeepExpression keepExpression) {
        this.buffer.append(keepExpression.toString());
    }

    @Override
    public void visit(MySQLGroupConcat mySQLGroupConcat) {
        this.buffer.append(mySQLGroupConcat.toString());
    }

    @Override
    public void visit(ExpressionList<?> expressionList) {
        ExpressionDeParser expressionDeParser = this;
        new ExpressionListDeParser(expressionDeParser, expressionDeParser.buffer).deParse(expressionList);
    }

    public void visit(RowConstructor rowConstructor) {
        if (rowConstructor.getName() != null) {
            this.buffer.append(rowConstructor.getName());
        }
        ExpressionDeParser expressionDeParser = this;
        new ExpressionListDeParser(expressionDeParser, expressionDeParser.buffer).deParse(rowConstructor);
    }

    @Override
    public void visit(RowGetExpression rowGetExpression) {
        rowGetExpression.getExpression().accept(this);
        this.buffer.append(".").append(rowGetExpression.getColumnName());
    }

    @Override
    public void visit(OracleHint oracleHint) {
        this.buffer.append(oracleHint.toString());
    }

    @Override
    public void visit(TimeKeyExpression timeKeyExpression) {
        this.buffer.append(timeKeyExpression.toString());
    }

    @Override
    public void visit(DateTimeLiteralExpression dateTimeLiteralExpression) {
        this.buffer.append(dateTimeLiteralExpression.toString());
    }

    @Override
    public void visit(NextValExpression nextValExpression) {
        this.buffer.append(nextValExpression.isUsingNextValueFor() ? "NEXT VALUE FOR " : "NEXTVAL FOR ").append(nextValExpression.getName());
    }

    @Override
    public void visit(CollateExpression collateExpression) {
        this.buffer.append(collateExpression.getLeftExpression().toString()).append(" COLLATE ").append(collateExpression.getCollate());
    }

    @Override
    public void visit(SimilarToExpression similarToExpression) {
        this.visitBinaryExpression(similarToExpression, (similarToExpression.isNot() ? " NOT" : "") + " SIMILAR TO ");
    }

    @Override
    public void visit(ArrayExpression arrayExpression) {
        arrayExpression.getObjExpression().accept(this);
        this.buffer.append("[");
        if (arrayExpression.getIndexExpression() != null) {
            arrayExpression.getIndexExpression().accept(this);
        } else {
            if (arrayExpression.getStartIndexExpression() != null) {
                arrayExpression.getStartIndexExpression().accept(this);
            }
            this.buffer.append(":");
            if (arrayExpression.getStopIndexExpression() != null) {
                arrayExpression.getStopIndexExpression().accept(this);
            }
        }
        this.buffer.append("]");
    }

    @Override
    public void visit(ArrayConstructor object) {
        if (((ArrayConstructor)object).isArrayKeyword()) {
            this.buffer.append("ARRAY");
        }
        this.buffer.append("[");
        boolean bl2 = true;
        for (Expression expression : ((ArrayConstructor)object).getExpressions()) {
            if (!bl2) {
                this.buffer.append(", ");
            } else {
                bl2 = false;
            }
            expression.accept(this);
        }
        this.buffer.append("]");
    }

    @Override
    void deParse(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visit(VariableAssignment variableAssignment) {
        variableAssignment.getVariable().accept(this);
        this.buffer.append(" ").append(variableAssignment.getOperation()).append(" ");
        variableAssignment.getExpression().accept(this);
    }

    @Override
    public void visit(XMLSerializeExpr xMLSerializeExpr) {
        this.buffer.append("xmlserialize(xmlagg(xmltext(");
        xMLSerializeExpr.getExpression().accept(this);
        this.buffer.append(")");
        if (xMLSerializeExpr.getOrderByElements() != null) {
            this.buffer.append(" ORDER BY ");
            Iterator<OrderByElement> iterator = xMLSerializeExpr.getOrderByElements().iterator();
            while (iterator.hasNext()) {
                this.buffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        this.buffer.append(") AS ").append(xMLSerializeExpr.getDataType()).append(")");
    }

    @Override
    public void visit(TimezoneExpression object) {
        ((TimezoneExpression)object).getLeftExpression().accept(this);
        for (Expression expression : ((TimezoneExpression)object).getTimezoneExpressions()) {
            this.buffer.append(" AT TIME ZONE ");
            expression.accept(this);
        }
    }

    @Override
    public void visit(JsonAggregateFunction jsonAggregateFunction) {
        jsonAggregateFunction.append(this.buffer);
    }

    @Override
    public void visit(JsonFunction jsonFunction) {
        jsonFunction.append(this.buffer);
    }

    @Override
    public void visit(ConnectByRootOperator connectByRootOperator) {
        this.buffer.append("CONNECT_BY_ROOT ");
        connectByRootOperator.getColumn().accept(this);
    }

    @Override
    public void visit(OracleNamedFunctionParameter oracleNamedFunctionParameter) {
        this.buffer.append(oracleNamedFunctionParameter.getName()).append(" => ");
        oracleNamedFunctionParameter.getExpression().accept(this);
    }

    @Override
    public void visit(AllColumns allColumns) {
        this.buffer.append(allColumns.toString());
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
        this.buffer.append(allTableColumns.toString());
    }

    @Override
    public void visit(AllValue allValue) {
        this.buffer.append(allValue);
    }

    @Override
    public void visit(IsDistinctExpression isDistinctExpression) {
        this.buffer.append(isDistinctExpression.getLeftExpression() + isDistinctExpression.getStringExpression() + isDistinctExpression.getRightExpression());
    }

    @Override
    public void visit(GeometryDistance geometryDistance) {
        this.visitOldOracleJoinBinaryExpression(geometryDistance, " " + geometryDistance.getStringExpression() + " ");
    }
}

