/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class RuleParameter<T> {
    private final DynamicRuleParameterEnum parameter;
    private final BiFunction<T, List<DynamicRuleParameter>, Boolean> validationCallbackOverride;
    private final Function<List<DynamicRuleParameter>, Boolean> shouldPrompt;
    private final Object defaultValueOverride;
    private final boolean allowEmpty;

    public RuleParameter(DynamicRuleParameterEnum parameter) {
        this(parameter, null, null);
    }

    public RuleParameter(DynamicRuleParameterEnum parameter, BiFunction<T, List<DynamicRuleParameter>, Boolean> validationCallbackOverride, Function<List<DynamicRuleParameter>, Boolean> shouldPrompt) {
        this(parameter, validationCallbackOverride, shouldPrompt, null, false);
    }

    public RuleParameter(DynamicRuleParameterEnum parameter, BiFunction<T, List<DynamicRuleParameter>, Boolean> validationCallbackOverride, Function<List<DynamicRuleParameter>, Boolean> shouldPrompt, Object defaultValueOverride, boolean allowEmpty) {
        this.parameter = parameter;
        this.validationCallbackOverride = validationCallbackOverride;
        this.shouldPrompt = shouldPrompt;
        this.defaultValueOverride = defaultValueOverride;
        this.allowEmpty = allowEmpty;
    }

    public Object getDefaultValue() {
        if (this.defaultValueOverride == null) {
            return this.parameter.defaultValue;
        }
        return this.defaultValueOverride;
    }

    public DynamicRuleParameterEnum getParameter() {
        return this.parameter;
    }

    public AbstractCommandLineValueGetter<?> getInteractiveCommandLineValueGetter() {
        return this.parameter.interactiveCommandLineValueGetter;
    }

    public BiFunction<T, List<DynamicRuleParameter>, Boolean> getValidationCallbackOverride() {
        return this.validationCallbackOverride;
    }

    public Function<List<DynamicRuleParameter>, Boolean> getShouldPrompt() {
        return this.shouldPrompt;
    }

    public String toString() {
        return this.getParameter().toString();
    }

    public boolean shouldPrompt(List<DynamicRuleParameter> existingNewValues) {
        boolean resp = true;
        if (this.shouldPrompt != null) {
            resp = this.shouldPrompt.apply(existingNewValues);
        }
        return resp;
    }

    public boolean allowEmpty() {
        return this.allowEmpty;
    }
}

