/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.UpdateOneChangeSetCommandStep;
import com.datical.liquibase.ext.command.UpdateReportGenerator;
import com.datical.liquibase.ext.command.helpers.RollbackOnErrorArgument;
import com.datical.liquibase.ext.command.helpers.VisibleReportCommandArguments;
import com.datical.liquibase.ext.reports.ReportArguments;
import java.util.ArrayList;
import java.util.List;
import liquibase.command.CommandOverride;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.MigrationFailedException;

@CommandOverride(override=UpdateOneChangeSetCommandStep.class)
public class ProUpdateOneChangesetCommandStep
extends UpdateOneChangeSetCommandStep {
    @Override
    public String[][] defineCommandNames() {
        return new String[][]{UpdateOneChangeSetCommandStep.COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        ArrayList deps = new ArrayList(super.requiredDependencies());
        deps.add(RollbackOnErrorArgument.class);
        deps.add(VisibleReportCommandArguments.class);
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        block6: {
            CommandScope commandScope = resultsBuilder.getCommandScope();
            Boolean rollbackOnError = (Boolean)commandScope.getDependency(RollbackOnErrorArgument.class);
            ReportArguments reportArguments = (ReportArguments)commandScope.getDependency(VisibleReportCommandArguments.class);
            try {
                super.run(resultsBuilder);
            }
            catch (Exception e) {
                Throwable migrationFailedException = this.findExceptionInCauseChain(e, MigrationFailedException.class);
                if (migrationFailedException != null) {
                    CommandScope rollbackOnErrorCommand = new CommandScope(new String[]{"internalRollbackOnError"});
                    rollbackOnErrorCommand.addArgumentValue("database", commandScope.getDependency(Database.class));
                    rollbackOnErrorCommand.addArgumentValue("exception", (Object)migrationFailedException);
                    rollbackOnErrorCommand.addArgumentValue("listener", resultsBuilder.getResult("defaultChangeExecListener"));
                    rollbackOnErrorCommand.addArgumentValue(RollbackOnErrorArgument.ROLLBACK_ON_ERROR_ARG, (Object)rollbackOnError);
                    rollbackOnErrorCommand.addArgumentValue("updateReportParameters.", resultsBuilder.getResult("updateReport"));
                    rollbackOnErrorCommand.execute();
                    break block6;
                }
                throw e;
            }
            finally {
                new UpdateReportGenerator().run(resultsBuilder, reportArguments);
            }
        }
    }

    private Throwable findExceptionInCauseChain(Throwable exceptionToSearchIn, Class<? extends Throwable> desiredCause) {
        if (exceptionToSearchIn == null || exceptionToSearchIn.getCause() == null) {
            return null;
        }
        if (desiredCause.isAssignableFrom(exceptionToSearchIn.getCause().getClass())) {
            return exceptionToSearchIn;
        }
        return this.findExceptionInCauseChain(exceptionToSearchIn.getCause(), desiredCause);
    }
}

