/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.init;

import com.datical.liquibase.ext.copy.ProjectCopier;
import com.datical.liquibase.ext.copy.ProjectCopierFactory;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.UnexpectedLiquibaseException;

public class InitCopyCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"init", "copy"};
    public static final CommandArgumentDefinition<String> INIT_COPY_SOURCE_DIR_ARG;
    public static final CommandArgumentDefinition<String> INIT_COPY_TARGET_DIR_ARG;
    public static final CommandArgumentDefinition<Boolean> INIT_COPY_RECURSIVE_ARG;
    public static final CommandArgumentDefinition<ProjectCopier> INIT_COPY_PROJECT_COPIER_ARG;

    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        ConfiguredValue sourceDirConfig = commandScope.getConfiguredValue(INIT_COPY_SOURCE_DIR_ARG);
        ConfiguredValue targetDirConfig = commandScope.getConfiguredValue(INIT_COPY_TARGET_DIR_ARG);
        ConfiguredValue recursiveConfig = commandScope.getConfiguredValue(INIT_COPY_RECURSIVE_ARG);
        String sourceDir = (String)sourceDirConfig.getValue();
        String targetDir = (String)targetDirConfig.getValue();
        Boolean recursive = (Boolean)recursiveConfig.getValue();
        ProjectCopier copier = this.determineProjectCopier(commandScope, targetDir);
        copier.copy(sourceDir, targetDir, recursive);
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Copy project files from the source directory to the target directory.");
        commandDefinition.setGroupShortDescription(new String[]{"init"}, "Init commands");
    }

    private ProjectCopier determineProjectCopier(CommandScope commandScope, String targetDir) {
        ProjectCopier copier = (ProjectCopier)commandScope.getConfiguredValue(INIT_COPY_PROJECT_COPIER_ARG).getValue();
        if (copier != null) {
            return copier;
        }
        ProjectCopierFactory factory = (ProjectCopierFactory)Scope.getCurrentScope().getSingleton(ProjectCopierFactory.class);
        copier = factory.getProjectCopier(targetDir);
        if (copier == null) {
            throw new UnexpectedLiquibaseException("Unable to locate a ProjectCopier instance on the classpath for '" + targetDir + "'");
        }
        return copier;
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        INIT_COPY_SOURCE_DIR_ARG = builder.argument("source", String.class).description("Path to the directory where the project files will be created").build();
        INIT_COPY_TARGET_DIR_ARG = builder.argument("target", String.class).description("Source directory where the project files will be copied from").defaultValue((Object)".").build();
        INIT_COPY_RECURSIVE_ARG = builder.argument("recursive", Boolean.class).description("Recursive copy files from the source directory").defaultValue((Object)false).build();
        INIT_COPY_PROJECT_COPIER_ARG = builder.argument("projectCopier", ProjectCopier.class).description("ProjectCopier object that can be passed in").hidden().build();
    }
}

