/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import java.util.Properties;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.StringUtil;

public class NativeRunnerUtil {
    public static void validateTimeout(Integer timeout) {
        if (timeout == null) {
            return;
        }
        if (timeout.equals(-1)) {
            return;
        }
        if (timeout.equals(0)) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of 0");
        }
        if (timeout < 1) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of '" + timeout + "'");
        }
    }

    public static Boolean getBooleanFromProperties(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (!(value == null || value.isEmpty() || (value = value.toLowerCase()).equals("true") || value.equals("false"))) {
            throw new UnexpectedLiquibaseException("Invalid value '" + value + "' for property '" + key + "'. Must be 'true' or 'false'.  Learn more at https://docs.liquibase.com");
        }
        return Boolean.valueOf(value);
    }

    public static String getExecutable(String executableName) {
        boolean isWindows = StringUtil.trimToEmpty((String)System.getProperties().getProperty("os.name")).toLowerCase().startsWith("windows");
        if (isWindows) {
            return String.format("%s.exe", executableName);
        }
        return executableName;
    }
}

