/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.codec;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.codec.Codec;
import net.java.truelicense.core.io.Sink;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.obfuscate.ObfuscatedString;

@Immutable
public class SerializationCodec
implements Codec {
    @Override
    public String contentType() {
        return SerializationCodec.CONTENT_TYPE();
    }

    @Override
    public String contentTransferEncoding() {
        return SerializationCodec.CONTENT_TRANSFER_ENCODING();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Sink sink, @Nullable Object object) throws Exception {
        OutputStream outputStream = sink.output();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            try {
                objectOutputStream.writeObject(object);
            }
            finally {
                objectOutputStream.close();
            }
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T decode(Source source, Type type) throws Exception {
        InputStream inputStream = source.input();
        try {
            Object object;
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            try {
                object = objectInputStream.readObject();
            }
            catch (Throwable throwable) {
                objectInputStream.close();
                throw throwable;
            }
            objectInputStream.close();
            return (T)object;
        }
        finally {
            inputStream.close();
        }
    }

    private static final /* synthetic */ String CONTENT_TYPE() {
        return new ObfuscatedString(new long[]{-2141492730197459962L, 2968137092072312615L, 4115450707735153430L, -2912018274771280305L, 2407218441968946517L, 4711948888813013412L}).toString();
    }

    private static final /* synthetic */ String CONTENT_TRANSFER_ENCODING() {
        return new ObfuscatedString(new long[]{4731929068000127405L, -2778534764945060896L}).toString();
    }
}

