/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.JSqlParserCache;
import com.datical.liquibase.ext.checks.SqlParseException;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicForecastRule;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.util.DatabaseObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.CreateTableChange;
import liquibase.changelog.ChangeSet;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;

public class TableMustHaveAComment
extends AbstractLiquibaseBasicForecastRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, BasicRule basicRule) {
        return this.doEvaluate(changeSet, basicRule, true);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, BasicRule basicRule) {
        return this.doEvaluate(changeSet, basicRule, false);
    }

    private boolean doEvaluate(ChangeSet changeSet, BasicRule basicRule, boolean isRollback) {
        List changes = changeSet.getChanges();
        for (Change change : changes) {
            if (change instanceof AbstractSQLChange) {
                try {
                    String[] splitSqls;
                    for (String splitSql : splitSqls = StringUtil.splitSQL((String)StringUtil.stripComments((String)this.getSql((AbstractSQLChange)change), (ChangeSet)changeSet), (String)((AbstractSQLChange)change).getEndDelimiter(), (ChangeSet)changeSet)) {
                        Statements statements = JSqlParserCache.parseSql(splitSql, true);
                        for (Statement statement : statements) {
                            if (!(statement instanceof CreateTable)) continue;
                            String tableName = ((CreateTable)statement).getTable().getName();
                            List tableOptionsStrings = CollectionUtil.createIfNull(((CreateTable)statement).getTableOptionsStrings());
                            boolean foundComment = false;
                            for (String tableOptionsString : tableOptionsStrings) {
                                if (!StringUtil.trimToEmpty((String)tableOptionsString).equalsIgnoreCase("comment")) continue;
                                foundComment = true;
                                break;
                            }
                            if (foundComment) continue;
                            this.addFailureRuleIteration(changeSet, this.buildErrorMessage(tableName), basicRule, isRollback);
                        }
                    }
                    continue;
                }
                catch (SqlParseException e) {
                    Level level = (Level)Scope.getCurrentScope().get(ChecksRunCommandStep.SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG.getName(), (Object)Level.FINE);
                    Scope.getCurrentScope().getLog(this.getClass()).log(level, "Failed to parse SQL", (Throwable)e);
                    this.addFailureRuleIteration(changeSet, "Some or all of the SQL could not be parsed by this check. Please review the changeset or SQL directly to make sure it is valid.", RuleIteration.FailureReason.SQL_PARSING, basicRule, isRollback);
                    continue;
                }
            }
            if (!(change instanceof CreateTableChange)) continue;
            String remarks = ((CreateTableChange)change).getRemarks();
            String tableName = ((CreateTableChange)change).getTableName();
            if (!StringUtil.isEmpty((String)remarks)) continue;
            this.addFailureRuleIteration(changeSet, this.buildErrorMessage(tableName), basicRule, isRollback);
        }
        return this.returnAtEndOfRule(changeSet, basicRule, isRollback);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, BasicRule basicRule) {
        if (databaseObject instanceof Table && StringUtil.isEmpty((String)((Table)databaseObject).getRemarks())) {
            this.addFailureRuleIteration(databaseObject, this.buildErrorMessage(DatabaseObjectUtils.buildFullyQualifiedName(databaseObject)), (AbstractConfigurableRule)basicRule);
        }
        return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)basicRule);
    }

    private String buildErrorMessage(String tableName) {
        return String.format("Table '%s' found without comment. Liquibase recommends tables have a comment to prevent siloed knowledge and to ensure table's purpose is easily understood by others. (Note: This is not a check for a Liquibase changelog comment.)", tableName);
    }

    @Override
    public String getDescription() {
        return "With database-scope, this check flags any table which does not have a comment. With changelog-scope, this check triggers on changesets with a CREATE table changetype that does not also add a comment for the table in that same changeset. (Note: This is not a check for a Liquibase changelog comment.)";
    }

    @Override
    public String getShortName() {
        return "TableCommentCheck";
    }

    @Override
    public int getPriority() {
        return 500;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }
}

