/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.license.LicenseServiceUtils;
import liquibase.parser.core.formattedsql.FormattedSqlChangeLogParser;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;

public class ProFormattedSqlChangeLogParser
extends FormattedSqlChangeLogParser {
    protected final String ROLLBACK_SQL_FILE_REGEX = String.format("\\s*%s[\\s]*rollbackSqlFile[\\s]+(.*)", this.getSingleLineCommentSequence());
    protected final Pattern ROLLBACK_SQL_FILE_PATTERN = Pattern.compile(this.ROLLBACK_SQL_FILE_REGEX, 2);
    protected static final String PATH_REGEX = ".*path:(\".*?\"|\\S*).*";
    protected final Pattern PATH_PATTERN = Pattern.compile(".*path:(\".*?\"|\\S*).*", 2);
    protected static final String RELATIVE_TO_CHANGELOG_REGEX = ".*relativeToChangelog:(\".*?\"|\\S*).*";
    protected final Pattern RELATIVE_TO_CHANGELOG_PATTERN = Pattern.compile(".*relativeToChangelog:(\".*?\"|\\S*).*", 2);

    public int getPriority() {
        return super.getPriority() + 5;
    }

    protected void configureChangeSet(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, BufferedReader reader, StringBuilder currentSequence, StringBuilder currentRollbackSequence, ChangeSet changeSet, int count, String line, Matcher commentMatcher, ResourceAccessor resourceAccessor) throws ChangeLogParseException, IOException {
        Matcher rollbackSqlFileMatcher = this.ROLLBACK_SQL_FILE_PATTERN.matcher(line);
        if (rollbackSqlFileMatcher.matches()) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                Scope.getCurrentScope().getUI().sendMessage("ERROR: Using rollback scripts with formatted SQL requires a valid Liquibase Pro key. Get a free license key at https://liquibase.com/trial. Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.");
            } else if (resourceAccessor != null) {
                String rollbackSqlAttributes = rollbackSqlFileMatcher.group(1);
                Matcher m = this.PATH_PATTERN.matcher(rollbackSqlAttributes);
                if (!m.matches()) {
                    String message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--rollbackSqlFile path:<SQL file path> [relativeToChangelog:true|false]", this.getDocumentationLink());
                    throw new ChangeLogParseException("\n" + message);
                }
                String path = DatabaseChangeLog.normalizePath((String)m.group(1));
                boolean isRelativeToChangelog = false;
                m = this.RELATIVE_TO_CHANGELOG_PATTERN.matcher(rollbackSqlAttributes);
                if (m.matches()) {
                    isRelativeToChangelog = Boolean.parseBoolean(m.group(1));
                }
                currentRollbackSequence.append(this.readRollbackSqlFile(path, resourceAccessor, physicalChangeLogLocation, isRelativeToChangelog));
            }
        } else {
            super.configureChangeSet(physicalChangeLogLocation, changeLogParameters, reader, currentSequence, currentRollbackSequence, changeSet, count, line, commentMatcher, resourceAccessor);
        }
    }

    protected String readRollbackSqlFile(String rollbackSpecification, ResourceAccessor resourceAccessor, String physicalChangelogLocation, boolean isRelativeToChangelog) throws IOException {
        if (isRelativeToChangelog) {
            rollbackSpecification = resourceAccessor.get(physicalChangelogLocation).resolveSibling(rollbackSpecification).getPath();
            rollbackSpecification = DatabaseChangeLog.normalizePath((String)Paths.get(rollbackSpecification, new String[0]).toString());
        }
        try (InputStream inputStream = resourceAccessor.get(rollbackSpecification).openInputStream();){
            String string = StreamUtil.readStreamAsString((InputStream)inputStream);
            return string;
        }
    }
}

