/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.markunused.change;

import com.datical.liquibase.ext.appdba.markunused.change.MarkUnusedStatement;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;

public class MarkUnusedGenerator
extends AbstractSqlGenerator<MarkUnusedStatement> {
    public ValidationErrors validate(MarkUnusedStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        validationErrors.checkRequiredField("columnName", (Object)statement.getColumnName());
        return validationErrors;
    }

    public boolean supports(MarkUnusedStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public Sql[] generateSql(MarkUnusedStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sql = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " SET UNUSED COLUMN " + database.escapeObjectName(statement.getColumnName(), Column.class);
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
    }
}

