/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractChainedChecksRule;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class ChainedChecksTemplate
extends AbstractChainedChecksRule {
    private static final String MESSAGE_TEMPLATE = "The conditions in '<chained checks shortname>' were met for '<logic conditional>'.  The chained checks include <checknames>.";

    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getDescription() {
        return "This check triggers when the logic conditional evaluates to true";
    }

    @Override
    public String getShortName() {
        return "ChainedChecksTemplate";
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule rule) {
        return true;
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        return true;
    }

    @Override
    public int getPriority() {
        return 515;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter<String>(DynamicRuleParameterEnum.LOGIC_CONDITIONAL, ChainedChecksTemplate::validateLogicConditional, null, null, false), new RuleParameter(DynamicRuleParameterEnum.MESSAGE, null, null, MESSAGE_TEMPLATE, false));
    }

    private static Boolean validateLogicConditional(String value, List<DynamicRuleParameter> newParameterValues) {
        CheckSettingsConfig csc = (CheckSettingsConfig)Scope.getCurrentScope().get("checkSettingsConfig", CheckSettingsConfig.class);
        if (csc == null) {
            Scope.getCurrentScope().getLog(ChainedChecksTemplate.class).warning("Unable to obtain CheckSettingsConfig for validation");
            return true;
        }
        ArrayList missing = new ArrayList();
        List<String> checks = DynamicRule.determineChecksFromConditional(value);
        HashMap<String, List> scopesMap = new HashMap<String, List>();
        checks.forEach(c -> {
            if (csc.getRuleByShortName((String)c) == null) {
                missing.add(c);
            } else {
                try {
                    AbstractLiquibaseRule r = AbstractChecksCommandStep.findRuleByShortName(c);
                    List<ScopeEnum> scopes = r.getScope();
                    scopesMap.put((String)c, scopes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        if (!missing.isEmpty()) {
            if (missing.size() == 1) {
                Scope.getCurrentScope().getUI().sendMessage(String.format("Check '%s' does not exist", missing));
            } else {
                Scope.getCurrentScope().getUI().sendMessage(String.format("Checks '%s' do not exist", StringUtil.join(missing, (String)",")));
            }
            return false;
        }
        AtomicReference<Boolean> anyMatch = new AtomicReference<Boolean>(true);
        AtomicReference firstScopes = new AtomicReference(new ArrayList());
        scopesMap.forEach((k, v) -> {
            if (((List)firstScopes.get()).isEmpty()) {
                firstScopes.set(v);
            } else if (Boolean.TRUE.equals(anyMatch.get())) {
                anyMatch.set(((List)firstScopes.get()).stream().anyMatch(v::contains));
            }
        });
        if (Boolean.FALSE.equals(anyMatch.get())) {
            Scope.getCurrentScope().getUI().sendMessage(String.format("The expression '%s' contains checks with mixed scope, which may give you unexpected results.", value));
            return false;
        }
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        checks.forEach(c -> variables.put((String)c, Boolean.TRUE));
        new ChainedChecksTemplate().execute(value, variables);
        return true;
    }
}

